/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.certificatemanager.model.ListCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class ListCertificatesRequestMarshaller
implements Marshaller<Request<ListCertificatesRequest>, ListCertificatesRequest> {
    public Request<ListCertificatesRequest> marshall(ListCertificatesRequest listCertificatesRequest) {
        if (listCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCertificatesRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.ListCertificates");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            List<String> certificateStatusesList = listCertificatesRequest.getCertificateStatuses();
            if (certificateStatusesList != null) {
                jsonWriter.key("CertificateStatuses");
                jsonWriter.array();
                for (String certificateStatusesListValue : certificateStatusesList) {
                    if (certificateStatusesListValue == null) continue;
                    jsonWriter.value((Object)certificateStatusesListValue);
                }
                jsonWriter.endArray();
            }
            if (listCertificatesRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)listCertificatesRequest.getNextToken());
            }
            if (listCertificatesRequest.getMaxItems() != null) {
                jsonWriter.key("MaxItems").value((Object)listCertificatesRequest.getMaxItems());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

