/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.accessanalyzer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains information about an unused access finding for an action. IAM Access Analyzer charges for unused access
 * analysis based on the number of IAM roles and users analyzed per month. For more details on pricing, see <a
 * href="https://aws.amazon.com/iam/access-analyzer/pricing">IAM Access Analyzer pricing</a>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UnusedAction" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UnusedAction implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The action for which the unused access finding was generated.
     * </p>
     */
    private String action;
    /**
     * <p>
     * The time at which the action was last accessed.
     * </p>
     */
    private java.util.Date lastAccessed;

    /**
     * <p>
     * The action for which the unused access finding was generated.
     * </p>
     * 
     * @param action
     *        The action for which the unused access finding was generated.
     */

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * <p>
     * The action for which the unused access finding was generated.
     * </p>
     * 
     * @return The action for which the unused access finding was generated.
     */

    public String getAction() {
        return this.action;
    }

    /**
     * <p>
     * The action for which the unused access finding was generated.
     * </p>
     * 
     * @param action
     *        The action for which the unused access finding was generated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UnusedAction withAction(String action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * The time at which the action was last accessed.
     * </p>
     * 
     * @param lastAccessed
     *        The time at which the action was last accessed.
     */

    public void setLastAccessed(java.util.Date lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    /**
     * <p>
     * The time at which the action was last accessed.
     * </p>
     * 
     * @return The time at which the action was last accessed.
     */

    public java.util.Date getLastAccessed() {
        return this.lastAccessed;
    }

    /**
     * <p>
     * The time at which the action was last accessed.
     * </p>
     * 
     * @param lastAccessed
     *        The time at which the action was last accessed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UnusedAction withLastAccessed(java.util.Date lastAccessed) {
        setLastAccessed(lastAccessed);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAction() != null)
            sb.append("Action: ").append(getAction()).append(",");
        if (getLastAccessed() != null)
            sb.append("LastAccessed: ").append(getLastAccessed());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UnusedAction == false)
            return false;
        UnusedAction other = (UnusedAction) obj;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        if (other.getLastAccessed() == null ^ this.getLastAccessed() == null)
            return false;
        if (other.getLastAccessed() != null && other.getLastAccessed().equals(this.getLastAccessed()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        hashCode = prime * hashCode + ((getLastAccessed() == null) ? 0 : getLastAccessed().hashCode());
        return hashCode;
    }

    @Override
    public UnusedAction clone() {
        try {
            return (UnusedAction) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.accessanalyzer.model.transform.UnusedActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
