/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.accessanalyzer.AWSAccessAnalyzerAsync;
import com.amazonaws.services.accessanalyzer.AWSAccessAnalyzerAsyncClientBuilder;
import com.amazonaws.services.accessanalyzer.AWSAccessAnalyzerClient;
import com.amazonaws.services.accessanalyzer.model.ApplyArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.ApplyArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.CancelPolicyGenerationRequest;
import com.amazonaws.services.accessanalyzer.model.CancelPolicyGenerationResult;
import com.amazonaws.services.accessanalyzer.model.CheckAccessNotGrantedRequest;
import com.amazonaws.services.accessanalyzer.model.CheckAccessNotGrantedResult;
import com.amazonaws.services.accessanalyzer.model.CheckNoNewAccessRequest;
import com.amazonaws.services.accessanalyzer.model.CheckNoNewAccessResult;
import com.amazonaws.services.accessanalyzer.model.CreateAccessPreviewRequest;
import com.amazonaws.services.accessanalyzer.model.CreateAccessPreviewResult;
import com.amazonaws.services.accessanalyzer.model.CreateAnalyzerRequest;
import com.amazonaws.services.accessanalyzer.model.CreateAnalyzerResult;
import com.amazonaws.services.accessanalyzer.model.CreateArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.CreateArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.DeleteAnalyzerRequest;
import com.amazonaws.services.accessanalyzer.model.DeleteAnalyzerResult;
import com.amazonaws.services.accessanalyzer.model.DeleteArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.DeleteArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.GetAccessPreviewRequest;
import com.amazonaws.services.accessanalyzer.model.GetAccessPreviewResult;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzedResourceRequest;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzedResourceResult;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzerRequest;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzerResult;
import com.amazonaws.services.accessanalyzer.model.GetArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.GetArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.GetFindingRequest;
import com.amazonaws.services.accessanalyzer.model.GetFindingResult;
import com.amazonaws.services.accessanalyzer.model.GetFindingV2Request;
import com.amazonaws.services.accessanalyzer.model.GetFindingV2Result;
import com.amazonaws.services.accessanalyzer.model.GetGeneratedPolicyRequest;
import com.amazonaws.services.accessanalyzer.model.GetGeneratedPolicyResult;
import com.amazonaws.services.accessanalyzer.model.ListAccessPreviewFindingsRequest;
import com.amazonaws.services.accessanalyzer.model.ListAccessPreviewFindingsResult;
import com.amazonaws.services.accessanalyzer.model.ListAccessPreviewsRequest;
import com.amazonaws.services.accessanalyzer.model.ListAccessPreviewsResult;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzedResourcesRequest;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzedResourcesResult;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzersRequest;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzersResult;
import com.amazonaws.services.accessanalyzer.model.ListArchiveRulesRequest;
import com.amazonaws.services.accessanalyzer.model.ListArchiveRulesResult;
import com.amazonaws.services.accessanalyzer.model.ListFindingsRequest;
import com.amazonaws.services.accessanalyzer.model.ListFindingsResult;
import com.amazonaws.services.accessanalyzer.model.ListFindingsV2Request;
import com.amazonaws.services.accessanalyzer.model.ListFindingsV2Result;
import com.amazonaws.services.accessanalyzer.model.ListPolicyGenerationsRequest;
import com.amazonaws.services.accessanalyzer.model.ListPolicyGenerationsResult;
import com.amazonaws.services.accessanalyzer.model.ListTagsForResourceRequest;
import com.amazonaws.services.accessanalyzer.model.ListTagsForResourceResult;
import com.amazonaws.services.accessanalyzer.model.StartPolicyGenerationRequest;
import com.amazonaws.services.accessanalyzer.model.StartPolicyGenerationResult;
import com.amazonaws.services.accessanalyzer.model.StartResourceScanRequest;
import com.amazonaws.services.accessanalyzer.model.StartResourceScanResult;
import com.amazonaws.services.accessanalyzer.model.TagResourceRequest;
import com.amazonaws.services.accessanalyzer.model.TagResourceResult;
import com.amazonaws.services.accessanalyzer.model.UntagResourceRequest;
import com.amazonaws.services.accessanalyzer.model.UntagResourceResult;
import com.amazonaws.services.accessanalyzer.model.UpdateArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.UpdateArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.UpdateFindingsRequest;
import com.amazonaws.services.accessanalyzer.model.UpdateFindingsResult;
import com.amazonaws.services.accessanalyzer.model.ValidatePolicyRequest;
import com.amazonaws.services.accessanalyzer.model.ValidatePolicyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAccessAnalyzerAsyncClient
extends AWSAccessAnalyzerClient
implements AWSAccessAnalyzerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAccessAnalyzerAsyncClientBuilder asyncBuilder() {
        return AWSAccessAnalyzerAsyncClientBuilder.standard();
    }

    AWSAccessAnalyzerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSAccessAnalyzerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ApplyArchiveRuleResult> applyArchiveRuleAsync(ApplyArchiveRuleRequest request) {
        return this.applyArchiveRuleAsync(request, null);
    }

    @Override
    public Future<ApplyArchiveRuleResult> applyArchiveRuleAsync(ApplyArchiveRuleRequest request, final AsyncHandler<ApplyArchiveRuleRequest, ApplyArchiveRuleResult> asyncHandler) {
        final ApplyArchiveRuleRequest finalRequest = (ApplyArchiveRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ApplyArchiveRuleResult>(){

            @Override
            public ApplyArchiveRuleResult call() throws Exception {
                ApplyArchiveRuleResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeApplyArchiveRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelPolicyGenerationResult> cancelPolicyGenerationAsync(CancelPolicyGenerationRequest request) {
        return this.cancelPolicyGenerationAsync(request, null);
    }

    @Override
    public Future<CancelPolicyGenerationResult> cancelPolicyGenerationAsync(CancelPolicyGenerationRequest request, final AsyncHandler<CancelPolicyGenerationRequest, CancelPolicyGenerationResult> asyncHandler) {
        final CancelPolicyGenerationRequest finalRequest = (CancelPolicyGenerationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelPolicyGenerationResult>(){

            @Override
            public CancelPolicyGenerationResult call() throws Exception {
                CancelPolicyGenerationResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeCancelPolicyGeneration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CheckAccessNotGrantedResult> checkAccessNotGrantedAsync(CheckAccessNotGrantedRequest request) {
        return this.checkAccessNotGrantedAsync(request, null);
    }

    @Override
    public Future<CheckAccessNotGrantedResult> checkAccessNotGrantedAsync(CheckAccessNotGrantedRequest request, final AsyncHandler<CheckAccessNotGrantedRequest, CheckAccessNotGrantedResult> asyncHandler) {
        final CheckAccessNotGrantedRequest finalRequest = (CheckAccessNotGrantedRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CheckAccessNotGrantedResult>(){

            @Override
            public CheckAccessNotGrantedResult call() throws Exception {
                CheckAccessNotGrantedResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeCheckAccessNotGranted(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CheckNoNewAccessResult> checkNoNewAccessAsync(CheckNoNewAccessRequest request) {
        return this.checkNoNewAccessAsync(request, null);
    }

    @Override
    public Future<CheckNoNewAccessResult> checkNoNewAccessAsync(CheckNoNewAccessRequest request, final AsyncHandler<CheckNoNewAccessRequest, CheckNoNewAccessResult> asyncHandler) {
        final CheckNoNewAccessRequest finalRequest = (CheckNoNewAccessRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CheckNoNewAccessResult>(){

            @Override
            public CheckNoNewAccessResult call() throws Exception {
                CheckNoNewAccessResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeCheckNoNewAccess(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAccessPreviewResult> createAccessPreviewAsync(CreateAccessPreviewRequest request) {
        return this.createAccessPreviewAsync(request, null);
    }

    @Override
    public Future<CreateAccessPreviewResult> createAccessPreviewAsync(CreateAccessPreviewRequest request, final AsyncHandler<CreateAccessPreviewRequest, CreateAccessPreviewResult> asyncHandler) {
        final CreateAccessPreviewRequest finalRequest = (CreateAccessPreviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAccessPreviewResult>(){

            @Override
            public CreateAccessPreviewResult call() throws Exception {
                CreateAccessPreviewResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeCreateAccessPreview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAnalyzerResult> createAnalyzerAsync(CreateAnalyzerRequest request) {
        return this.createAnalyzerAsync(request, null);
    }

    @Override
    public Future<CreateAnalyzerResult> createAnalyzerAsync(CreateAnalyzerRequest request, final AsyncHandler<CreateAnalyzerRequest, CreateAnalyzerResult> asyncHandler) {
        final CreateAnalyzerRequest finalRequest = (CreateAnalyzerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAnalyzerResult>(){

            @Override
            public CreateAnalyzerResult call() throws Exception {
                CreateAnalyzerResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeCreateAnalyzer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateArchiveRuleResult> createArchiveRuleAsync(CreateArchiveRuleRequest request) {
        return this.createArchiveRuleAsync(request, null);
    }

    @Override
    public Future<CreateArchiveRuleResult> createArchiveRuleAsync(CreateArchiveRuleRequest request, final AsyncHandler<CreateArchiveRuleRequest, CreateArchiveRuleResult> asyncHandler) {
        final CreateArchiveRuleRequest finalRequest = (CreateArchiveRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateArchiveRuleResult>(){

            @Override
            public CreateArchiveRuleResult call() throws Exception {
                CreateArchiveRuleResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeCreateArchiveRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAnalyzerResult> deleteAnalyzerAsync(DeleteAnalyzerRequest request) {
        return this.deleteAnalyzerAsync(request, null);
    }

    @Override
    public Future<DeleteAnalyzerResult> deleteAnalyzerAsync(DeleteAnalyzerRequest request, final AsyncHandler<DeleteAnalyzerRequest, DeleteAnalyzerResult> asyncHandler) {
        final DeleteAnalyzerRequest finalRequest = (DeleteAnalyzerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAnalyzerResult>(){

            @Override
            public DeleteAnalyzerResult call() throws Exception {
                DeleteAnalyzerResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeDeleteAnalyzer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteArchiveRuleResult> deleteArchiveRuleAsync(DeleteArchiveRuleRequest request) {
        return this.deleteArchiveRuleAsync(request, null);
    }

    @Override
    public Future<DeleteArchiveRuleResult> deleteArchiveRuleAsync(DeleteArchiveRuleRequest request, final AsyncHandler<DeleteArchiveRuleRequest, DeleteArchiveRuleResult> asyncHandler) {
        final DeleteArchiveRuleRequest finalRequest = (DeleteArchiveRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteArchiveRuleResult>(){

            @Override
            public DeleteArchiveRuleResult call() throws Exception {
                DeleteArchiveRuleResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeDeleteArchiveRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccessPreviewResult> getAccessPreviewAsync(GetAccessPreviewRequest request) {
        return this.getAccessPreviewAsync(request, null);
    }

    @Override
    public Future<GetAccessPreviewResult> getAccessPreviewAsync(GetAccessPreviewRequest request, final AsyncHandler<GetAccessPreviewRequest, GetAccessPreviewResult> asyncHandler) {
        final GetAccessPreviewRequest finalRequest = (GetAccessPreviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccessPreviewResult>(){

            @Override
            public GetAccessPreviewResult call() throws Exception {
                GetAccessPreviewResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeGetAccessPreview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAnalyzedResourceResult> getAnalyzedResourceAsync(GetAnalyzedResourceRequest request) {
        return this.getAnalyzedResourceAsync(request, null);
    }

    @Override
    public Future<GetAnalyzedResourceResult> getAnalyzedResourceAsync(GetAnalyzedResourceRequest request, final AsyncHandler<GetAnalyzedResourceRequest, GetAnalyzedResourceResult> asyncHandler) {
        final GetAnalyzedResourceRequest finalRequest = (GetAnalyzedResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAnalyzedResourceResult>(){

            @Override
            public GetAnalyzedResourceResult call() throws Exception {
                GetAnalyzedResourceResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeGetAnalyzedResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAnalyzerResult> getAnalyzerAsync(GetAnalyzerRequest request) {
        return this.getAnalyzerAsync(request, null);
    }

    @Override
    public Future<GetAnalyzerResult> getAnalyzerAsync(GetAnalyzerRequest request, final AsyncHandler<GetAnalyzerRequest, GetAnalyzerResult> asyncHandler) {
        final GetAnalyzerRequest finalRequest = (GetAnalyzerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAnalyzerResult>(){

            @Override
            public GetAnalyzerResult call() throws Exception {
                GetAnalyzerResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeGetAnalyzer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetArchiveRuleResult> getArchiveRuleAsync(GetArchiveRuleRequest request) {
        return this.getArchiveRuleAsync(request, null);
    }

    @Override
    public Future<GetArchiveRuleResult> getArchiveRuleAsync(GetArchiveRuleRequest request, final AsyncHandler<GetArchiveRuleRequest, GetArchiveRuleResult> asyncHandler) {
        final GetArchiveRuleRequest finalRequest = (GetArchiveRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetArchiveRuleResult>(){

            @Override
            public GetArchiveRuleResult call() throws Exception {
                GetArchiveRuleResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeGetArchiveRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingResult> getFindingAsync(GetFindingRequest request) {
        return this.getFindingAsync(request, null);
    }

    @Override
    public Future<GetFindingResult> getFindingAsync(GetFindingRequest request, final AsyncHandler<GetFindingRequest, GetFindingResult> asyncHandler) {
        final GetFindingRequest finalRequest = (GetFindingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingResult>(){

            @Override
            public GetFindingResult call() throws Exception {
                GetFindingResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeGetFinding(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingV2Result> getFindingV2Async(GetFindingV2Request request) {
        return this.getFindingV2Async(request, null);
    }

    @Override
    public Future<GetFindingV2Result> getFindingV2Async(GetFindingV2Request request, final AsyncHandler<GetFindingV2Request, GetFindingV2Result> asyncHandler) {
        final GetFindingV2Request finalRequest = (GetFindingV2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingV2Result>(){

            @Override
            public GetFindingV2Result call() throws Exception {
                GetFindingV2Result result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeGetFindingV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGeneratedPolicyResult> getGeneratedPolicyAsync(GetGeneratedPolicyRequest request) {
        return this.getGeneratedPolicyAsync(request, null);
    }

    @Override
    public Future<GetGeneratedPolicyResult> getGeneratedPolicyAsync(GetGeneratedPolicyRequest request, final AsyncHandler<GetGeneratedPolicyRequest, GetGeneratedPolicyResult> asyncHandler) {
        final GetGeneratedPolicyRequest finalRequest = (GetGeneratedPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGeneratedPolicyResult>(){

            @Override
            public GetGeneratedPolicyResult call() throws Exception {
                GetGeneratedPolicyResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeGetGeneratedPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccessPreviewFindingsResult> listAccessPreviewFindingsAsync(ListAccessPreviewFindingsRequest request) {
        return this.listAccessPreviewFindingsAsync(request, null);
    }

    @Override
    public Future<ListAccessPreviewFindingsResult> listAccessPreviewFindingsAsync(ListAccessPreviewFindingsRequest request, final AsyncHandler<ListAccessPreviewFindingsRequest, ListAccessPreviewFindingsResult> asyncHandler) {
        final ListAccessPreviewFindingsRequest finalRequest = (ListAccessPreviewFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccessPreviewFindingsResult>(){

            @Override
            public ListAccessPreviewFindingsResult call() throws Exception {
                ListAccessPreviewFindingsResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListAccessPreviewFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccessPreviewsResult> listAccessPreviewsAsync(ListAccessPreviewsRequest request) {
        return this.listAccessPreviewsAsync(request, null);
    }

    @Override
    public Future<ListAccessPreviewsResult> listAccessPreviewsAsync(ListAccessPreviewsRequest request, final AsyncHandler<ListAccessPreviewsRequest, ListAccessPreviewsResult> asyncHandler) {
        final ListAccessPreviewsRequest finalRequest = (ListAccessPreviewsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccessPreviewsResult>(){

            @Override
            public ListAccessPreviewsResult call() throws Exception {
                ListAccessPreviewsResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListAccessPreviews(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAnalyzedResourcesResult> listAnalyzedResourcesAsync(ListAnalyzedResourcesRequest request) {
        return this.listAnalyzedResourcesAsync(request, null);
    }

    @Override
    public Future<ListAnalyzedResourcesResult> listAnalyzedResourcesAsync(ListAnalyzedResourcesRequest request, final AsyncHandler<ListAnalyzedResourcesRequest, ListAnalyzedResourcesResult> asyncHandler) {
        final ListAnalyzedResourcesRequest finalRequest = (ListAnalyzedResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAnalyzedResourcesResult>(){

            @Override
            public ListAnalyzedResourcesResult call() throws Exception {
                ListAnalyzedResourcesResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListAnalyzedResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAnalyzersResult> listAnalyzersAsync(ListAnalyzersRequest request) {
        return this.listAnalyzersAsync(request, null);
    }

    @Override
    public Future<ListAnalyzersResult> listAnalyzersAsync(ListAnalyzersRequest request, final AsyncHandler<ListAnalyzersRequest, ListAnalyzersResult> asyncHandler) {
        final ListAnalyzersRequest finalRequest = (ListAnalyzersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAnalyzersResult>(){

            @Override
            public ListAnalyzersResult call() throws Exception {
                ListAnalyzersResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListAnalyzers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListArchiveRulesResult> listArchiveRulesAsync(ListArchiveRulesRequest request) {
        return this.listArchiveRulesAsync(request, null);
    }

    @Override
    public Future<ListArchiveRulesResult> listArchiveRulesAsync(ListArchiveRulesRequest request, final AsyncHandler<ListArchiveRulesRequest, ListArchiveRulesResult> asyncHandler) {
        final ListArchiveRulesRequest finalRequest = (ListArchiveRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListArchiveRulesResult>(){

            @Override
            public ListArchiveRulesResult call() throws Exception {
                ListArchiveRulesResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListArchiveRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request) {
        return this.listFindingsAsync(request, null);
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request, final AsyncHandler<ListFindingsRequest, ListFindingsResult> asyncHandler) {
        final ListFindingsRequest finalRequest = (ListFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFindingsResult>(){

            @Override
            public ListFindingsResult call() throws Exception {
                ListFindingsResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsV2Result> listFindingsV2Async(ListFindingsV2Request request) {
        return this.listFindingsV2Async(request, null);
    }

    @Override
    public Future<ListFindingsV2Result> listFindingsV2Async(ListFindingsV2Request request, final AsyncHandler<ListFindingsV2Request, ListFindingsV2Result> asyncHandler) {
        final ListFindingsV2Request finalRequest = (ListFindingsV2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFindingsV2Result>(){

            @Override
            public ListFindingsV2Result call() throws Exception {
                ListFindingsV2Result result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListFindingsV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPolicyGenerationsResult> listPolicyGenerationsAsync(ListPolicyGenerationsRequest request) {
        return this.listPolicyGenerationsAsync(request, null);
    }

    @Override
    public Future<ListPolicyGenerationsResult> listPolicyGenerationsAsync(ListPolicyGenerationsRequest request, final AsyncHandler<ListPolicyGenerationsRequest, ListPolicyGenerationsResult> asyncHandler) {
        final ListPolicyGenerationsRequest finalRequest = (ListPolicyGenerationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPolicyGenerationsResult>(){

            @Override
            public ListPolicyGenerationsResult call() throws Exception {
                ListPolicyGenerationsResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListPolicyGenerations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPolicyGenerationResult> startPolicyGenerationAsync(StartPolicyGenerationRequest request) {
        return this.startPolicyGenerationAsync(request, null);
    }

    @Override
    public Future<StartPolicyGenerationResult> startPolicyGenerationAsync(StartPolicyGenerationRequest request, final AsyncHandler<StartPolicyGenerationRequest, StartPolicyGenerationResult> asyncHandler) {
        final StartPolicyGenerationRequest finalRequest = (StartPolicyGenerationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartPolicyGenerationResult>(){

            @Override
            public StartPolicyGenerationResult call() throws Exception {
                StartPolicyGenerationResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeStartPolicyGeneration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartResourceScanResult> startResourceScanAsync(StartResourceScanRequest request) {
        return this.startResourceScanAsync(request, null);
    }

    @Override
    public Future<StartResourceScanResult> startResourceScanAsync(StartResourceScanRequest request, final AsyncHandler<StartResourceScanRequest, StartResourceScanResult> asyncHandler) {
        final StartResourceScanRequest finalRequest = (StartResourceScanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartResourceScanResult>(){

            @Override
            public StartResourceScanResult call() throws Exception {
                StartResourceScanResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeStartResourceScan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateArchiveRuleResult> updateArchiveRuleAsync(UpdateArchiveRuleRequest request) {
        return this.updateArchiveRuleAsync(request, null);
    }

    @Override
    public Future<UpdateArchiveRuleResult> updateArchiveRuleAsync(UpdateArchiveRuleRequest request, final AsyncHandler<UpdateArchiveRuleRequest, UpdateArchiveRuleResult> asyncHandler) {
        final UpdateArchiveRuleRequest finalRequest = (UpdateArchiveRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateArchiveRuleResult>(){

            @Override
            public UpdateArchiveRuleResult call() throws Exception {
                UpdateArchiveRuleResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeUpdateArchiveRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFindingsResult> updateFindingsAsync(UpdateFindingsRequest request) {
        return this.updateFindingsAsync(request, null);
    }

    @Override
    public Future<UpdateFindingsResult> updateFindingsAsync(UpdateFindingsRequest request, final AsyncHandler<UpdateFindingsRequest, UpdateFindingsResult> asyncHandler) {
        final UpdateFindingsRequest finalRequest = (UpdateFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFindingsResult>(){

            @Override
            public UpdateFindingsResult call() throws Exception {
                UpdateFindingsResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeUpdateFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ValidatePolicyResult> validatePolicyAsync(ValidatePolicyRequest request) {
        return this.validatePolicyAsync(request, null);
    }

    @Override
    public Future<ValidatePolicyResult> validatePolicyAsync(ValidatePolicyRequest request, final AsyncHandler<ValidatePolicyRequest, ValidatePolicyResult> asyncHandler) {
        final ValidatePolicyRequest finalRequest = (ValidatePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ValidatePolicyResult>(){

            @Override
            public ValidatePolicyResult call() throws Exception {
                ValidatePolicyResult result = null;
                try {
                    result = AWSAccessAnalyzerAsyncClient.this.executeValidatePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

