/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.RdsDbSnapshotAttributeValue;
import com.amazonaws.services.accessanalyzer.model.transform.RdsDbSnapshotConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RdsDbSnapshotConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, RdsDbSnapshotAttributeValue> attributes;
    private String kmsKeyId;

    public Map<String, RdsDbSnapshotAttributeValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, RdsDbSnapshotAttributeValue> attributes) {
        this.attributes = attributes;
    }

    public RdsDbSnapshotConfiguration withAttributes(Map<String, RdsDbSnapshotAttributeValue> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public RdsDbSnapshotConfiguration addAttributesEntry(String key, RdsDbSnapshotAttributeValue value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, RdsDbSnapshotAttributeValue>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public RdsDbSnapshotConfiguration clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public RdsDbSnapshotConfiguration withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbSnapshotConfiguration)) {
            return false;
        }
        RdsDbSnapshotConfiguration other = (RdsDbSnapshotConfiguration)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        return other.getKmsKeyId() == null || other.getKmsKeyId().equals(this.getKmsKeyId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        return hashCode;
    }

    public RdsDbSnapshotConfiguration clone() {
        try {
            return (RdsDbSnapshotConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RdsDbSnapshotConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

