/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.CloudTrailProperties;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CloudTrailPropertiesMarshaller {
    private static final MarshallingInfo<List> TRAILPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("trailProperties").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final CloudTrailPropertiesMarshaller instance = new CloudTrailPropertiesMarshaller();

    public static CloudTrailPropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudTrailProperties cloudTrailProperties, ProtocolMarshaller protocolMarshaller) {
        if (cloudTrailProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cloudTrailProperties.getTrailProperties(), TRAILPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)cloudTrailProperties.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)cloudTrailProperties.getEndTime(), ENDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

