/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.CryptoMaterialsManager;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.CannotUnwrapDataKeyException;
import com.amazonaws.encryptionsdk.internal.TrailingSignatureAlgorithm;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.DecryptionMaterials;
import com.amazonaws.encryptionsdk.model.DecryptionMaterialsRequest;
import com.amazonaws.encryptionsdk.model.EncryptionMaterials;
import com.amazonaws.encryptionsdk.model.EncryptionMaterialsRequest;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultCryptoMaterialsManager
implements CryptoMaterialsManager {
    private final MasterKeyProvider<?> mkp;

    public DefaultCryptoMaterialsManager(MasterKeyProvider<?> mkp) {
        Utils.assertNonNull(mkp, "mkp");
        this.mkp = mkp;
    }

    @Override
    public EncryptionMaterials getMaterialsForEncrypt(EncryptionMaterialsRequest request) {
        Map<String, String> context = request.getContext();
        CryptoAlgorithm algo = request.getRequestedAlgorithm();
        if (algo == null) {
            algo = AwsCrypto.getDefaultCryptoAlgorithm();
        }
        KeyPair trailingKeys = null;
        if (algo.getTrailingSignatureLength() > 0) {
            try {
                trailingKeys = DefaultCryptoMaterialsManager.generateTrailingSigKeyPair(algo);
                if (context.containsKey("aws-crypto-public-key")) {
                    throw new IllegalArgumentException("EncryptionContext contains reserved field aws-crypto-public-key");
                }
                context = new HashMap<String, String>(context);
                context.put("aws-crypto-public-key", DefaultCryptoMaterialsManager.serializeTrailingKeyForEc(algo, trailingKeys));
            }
            catch (GeneralSecurityException ex) {
                throw new AwsCryptoException(ex);
            }
        }
        MasterKeyRequest.Builder mkRequestBuilder = MasterKeyRequest.newBuilder();
        mkRequestBuilder.setEncryptionContext(context);
        mkRequestBuilder.setStreaming(request.getPlaintextSize() == -1L);
        if (request.getPlaintext() != null) {
            mkRequestBuilder.setPlaintext(request.getPlaintext());
        } else {
            mkRequestBuilder.setSize(request.getPlaintextSize());
        }
        List<MasterKey> mks = Utils.assertNonNull(this.mkp, "provider").getMasterKeysForEncryption(mkRequestBuilder.build());
        if (mks.isEmpty()) {
            throw new IllegalArgumentException("No master keys provided");
        }
        DataKey dataKey = ((MasterKey)mks.get(0)).generateDataKey(algo, context);
        ArrayList<KeyBlob> keyBlobs = new ArrayList<KeyBlob>(mks.size());
        keyBlobs.add(new KeyBlob(dataKey));
        for (int i = 1; i < mks.size(); ++i) {
            keyBlobs.add(new KeyBlob(((MasterKey)mks.get(i)).encryptDataKey(algo, context, dataKey)));
        }
        return EncryptionMaterials.newBuilder().setAlgorithm(algo).setCleartextDataKey(dataKey.getKey()).setEncryptedDataKeys(keyBlobs).setEncryptionContext(context).setTrailingSignatureKey(trailingKeys == null ? null : trailingKeys.getPrivate()).setMasterKeys(mks).build();
    }

    @Override
    public DecryptionMaterials decryptMaterials(DecryptionMaterialsRequest request) {
        DataKey<?> dataKey = this.mkp.decryptDataKey(request.getAlgorithm(), request.getEncryptedDataKeys(), request.getEncryptionContext());
        if (dataKey == null) {
            throw new CannotUnwrapDataKeyException("Could not decrypt any data keys");
        }
        PublicKey pubKey = null;
        if (request.getAlgorithm().getTrailingSignatureLength() > 0) {
            try {
                String serializedPubKey = request.getEncryptionContext().get("aws-crypto-public-key");
                if (serializedPubKey == null) {
                    throw new AwsCryptoException("Missing trailing signature public key");
                }
                pubKey = this.deserializeTrailingKeyFromEc(request.getAlgorithm(), serializedPubKey);
            }
            catch (IllegalStateException ex) {
                throw new AwsCryptoException(ex);
            }
        }
        return DecryptionMaterials.newBuilder().setDataKey(dataKey).setTrailingSignatureKey(pubKey).build();
    }

    private PublicKey deserializeTrailingKeyFromEc(CryptoAlgorithm algo, String pubKey) {
        return TrailingSignatureAlgorithm.forCryptoAlgorithm(algo).deserializePublicKey(pubKey);
    }

    private static String serializeTrailingKeyForEc(CryptoAlgorithm algo, KeyPair trailingKeys) {
        return TrailingSignatureAlgorithm.forCryptoAlgorithm(algo).serializePublicKey(trailingKeys.getPublic());
    }

    private static KeyPair generateTrailingSigKeyPair(CryptoAlgorithm algo) throws GeneralSecurityException {
        return TrailingSignatureAlgorithm.forCryptoAlgorithm(algo).generateKey();
    }
}

