/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Comparator;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class Utils {
    private static final ThreadLocal<SecureRandom> LOCAL_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            SecureRandom rnd = new SecureRandom();
            rnd.nextBoolean();
            return rnd;
        }
    };
    private static AtomicLong FALLBACK_COUNTER = new AtomicLong(0L);
    private static WeakHashMap<Object, Long> FALLBACK_COMPARATOR_MAP = new WeakHashMap();

    private Utils() {
    }

    private static synchronized long getFallbackObjectId(Object object) {
        return FALLBACK_COMPARATOR_MAP.computeIfAbsent(object, ignored -> FALLBACK_COUNTER.incrementAndGet());
    }

    public static int compareObjectIdentity(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int hashCompare = Integer.compare(System.identityHashCode(a), System.identityHashCode(b));
        if (hashCompare != 0) {
            return hashCompare;
        }
        int fallbackCompare = Long.compare(Utils.getFallbackObjectId(a), Utils.getFallbackObjectId(b));
        if (fallbackCompare == 0) {
            throw new AssertionError((Object)"Failed to assign unique order to objects");
        }
        return fallbackCompare;
    }

    public static long saturatingAdd(long a, long b) {
        long r = a + b;
        if (a > 0L && b > 0L && r < a) {
            return Long.MAX_VALUE;
        }
        if (a < 0L && b < 0L && r > a) {
            return Long.MIN_VALUE;
        }
        return r;
    }

    public static <T> T assertNonNull(T object, String paramName) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException(paramName + " must not be null");
        }
        return object;
    }

    public static byte[] truncate(byte[] arr, int len) throws IllegalArgumentException {
        if (arr.length == len) {
            return arr;
        }
        if (arr.length > len) {
            return Arrays.copyOf(arr, len);
        }
        throw new IllegalArgumentException("arr is not at least " + len + " elements long");
    }

    public static SecureRandom getSecureRandom() {
        return LOCAL_RANDOM.get();
    }

    static byte[] generateContentAad(byte[] messageId, String idString, int seqNum, long len) {
        byte[] idBytes = idString.getBytes(StandardCharsets.UTF_8);
        int aadLen = messageId.length + idBytes.length + 4 + 8;
        ByteBuffer aad = ByteBuffer.allocate(aadLen);
        aad.put(messageId);
        aad.put(idBytes);
        aad.putInt(seqNum);
        aad.putLong(len);
        return aad.array();
    }

    static IllegalArgumentException cannotBeNegative(String field) {
        return new IllegalArgumentException(field + " cannot be negative");
    }

    public static ByteBuffer flip(ByteBuffer buff) {
        ((Buffer)buff).flip();
        return buff;
    }

    public static ByteBuffer clear(ByteBuffer buff) {
        ((Buffer)buff).clear();
        return buff;
    }

    public static ByteBuffer position(ByteBuffer buff, int newPosition) {
        ((Buffer)buff).position(newPosition);
        return buff;
    }

    public static ByteBuffer limit(ByteBuffer buff, int newLimit) {
        ((Buffer)buff).limit(newLimit);
        return buff;
    }

    public static class ComparingByteBuffers
    implements Comparator<ByteBuffer>,
    Serializable {
        private static final long serialVersionUID = -6646003325227765693L;

        @Override
        public int compare(ByteBuffer o1, ByteBuffer o2) {
            o1 = o1.slice();
            o2 = o2.slice();
            int commonLength = Math.min(o1.remaining(), o2.remaining());
            for (int i = 0; i < commonLength; ++i) {
                int v2;
                int v1 = o1.get(i) & 0xFF;
                if (v1 == (v2 = o2.get(i) & 0xFF)) continue;
                return v1 - v2;
            }
            return o1.remaining() - o2.remaining();
        }
    }

    public static class ComparingByteArrays
    implements Comparator<byte[]>,
    Serializable {
        private static final long serialVersionUID = -2349735272878110238L;

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return new ComparingByteBuffers().compare(ByteBuffer.wrap(o1), ByteBuffer.wrap(o2));
        }
    }
}

