/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.internal.BouncyCastleConfiguration;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;

public enum CryptoAlgorithm {
    ALG_AES_128_GCM_IV12_TAG16_NO_KDF(128, 12, 16, 0xFFFFFFFE0L, "AES", 16, 20, "AES", 16, false),
    ALG_AES_192_GCM_IV12_TAG16_NO_KDF(128, 12, 16, 0xFFFFFFFE0L, "AES", 24, 70, "AES", 24, false),
    ALG_AES_256_GCM_IV12_TAG16_NO_KDF(128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 120, "AES", 32, false),
    ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256(128, 12, 16, 0xFFFFFFFE0L, "AES", 16, 276, "HkdfSHA256", 16, true),
    ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA256(128, 12, 16, 0xFFFFFFFE0L, "AES", 24, 326, "HkdfSHA256", 24, true),
    ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA256(128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 376, "HkdfSHA256", 32, true),
    ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256(128, 12, 16, 0xFFFFFFFE0L, "AES", 16, 532, "HkdfSHA256", 16, true, "SHA256withECDSA", 71),
    ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384(128, 12, 16, 0xFFFFFFFE0L, "AES", 24, 838, "HkdfSHA384", 24, true, "SHA384withECDSA", 103),
    ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384(128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 888, "HkdfSHA384", 32, true, "SHA384withECDSA", 103);

    private final int blockSizeBits_;
    private final byte nonceLenBytes_;
    private final int tagLenBytes_;
    private final long maxContentLen_;
    private final String keyAlgo_;
    private final int keyLenBytes_;
    private final short value_;
    private final String trailingSigAlgo_;
    private final short trailingSigLen_;
    private final String dataKeyAlgo_;
    private final int dataKeyLen_;
    private final boolean safeToCache_;
    private static final Map<Short, CryptoAlgorithm> ID_MAPPING;

    private CryptoAlgorithm(int blockSizeBits, int nonceLenBytes, int tagLenBytes, long maxContentLen, String keyAlgo, int keyLenBytes, int value, String dataKeyAlgo, int dataKeyLen, boolean safeToCache) {
        this(blockSizeBits, nonceLenBytes, tagLenBytes, maxContentLen, keyAlgo, keyLenBytes, value, dataKeyAlgo, dataKeyLen, safeToCache, null, 0);
    }

    private CryptoAlgorithm(int blockSizeBits, int nonceLenBytes, int tagLenBytes, long maxContentLen, String keyAlgo, int keyLenBytes, int value, String dataKeyAlgo, int dataKeyLen, boolean safeToCache, String trailingSignatureAlgo, int trailingSignatureLength) {
        this.blockSizeBits_ = blockSizeBits;
        this.nonceLenBytes_ = (byte)nonceLenBytes;
        this.tagLenBytes_ = tagLenBytes;
        this.keyAlgo_ = keyAlgo;
        this.keyLenBytes_ = keyLenBytes;
        this.maxContentLen_ = maxContentLen;
        this.safeToCache_ = safeToCache;
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Invalid value " + value);
        }
        this.value_ = (short)value;
        this.dataKeyAlgo_ = dataKeyAlgo;
        this.dataKeyLen_ = dataKeyLen;
        this.trailingSigAlgo_ = trailingSignatureAlgo;
        if (trailingSignatureLength > Short.MAX_VALUE || trailingSignatureLength < 0) {
            throw new IllegalArgumentException("Invalid value " + trailingSignatureLength);
        }
        this.trailingSigLen_ = (short)trailingSignatureLength;
    }

    public static CryptoAlgorithm deserialize(short value) {
        CryptoAlgorithm result = ID_MAPPING.get(value);
        return result;
    }

    public int getBlockSize() {
        return this.blockSizeBits_ / 8;
    }

    public byte getNonceLen() {
        return this.nonceLenBytes_;
    }

    public int getTagLen() {
        return this.tagLenBytes_;
    }

    public long getMaxContentLen() {
        return this.maxContentLen_;
    }

    public String getKeyAlgo() {
        return this.keyAlgo_;
    }

    public int getKeyLength() {
        return this.keyLenBytes_;
    }

    public short getValue() {
        return this.value_;
    }

    public String getDataKeyAlgo() {
        return this.dataKeyAlgo_;
    }

    public int getDataKeyLength() {
        return this.dataKeyLen_;
    }

    public String getTrailingSignatureAlgo() {
        return this.trailingSigAlgo_;
    }

    public boolean isSafeToCache() {
        return this.safeToCache_;
    }

    public short getTrailingSignatureLength() {
        return this.trailingSigLen_;
    }

    public SecretKey getEncryptionKeyFromDataKey(SecretKey dataKey, CiphertextHeaders headers) throws InvalidKeyException {
        SHA256Digest dgst;
        if (!dataKey.getAlgorithm().equalsIgnoreCase(this.getDataKeyAlgo())) {
            throw new InvalidKeyException("DataKey of incorrect algorithm. Expected " + this.getDataKeyAlgo() + " but was " + dataKey.getAlgorithm());
        }
        switch (this) {
            case ALG_AES_128_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_192_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: {
                return dataKey;
            }
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: {
                dgst = new SHA256Digest();
                break;
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                dgst = new SHA384Digest();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Support for " + (Object)((Object)this) + " not yet built.");
            }
        }
        if (!dataKey.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Currently only RAW format keys are supported for HKDF algorithms. Actual format was " + dataKey.getFormat());
        }
        byte[] messageId = headers.getMessageId();
        ByteBuffer info = ByteBuffer.allocate(messageId.length + 2);
        info.order(ByteOrder.BIG_ENDIAN);
        info.putShort(this.getValue());
        info.put(messageId);
        byte[] rawDataKey = dataKey.getEncoded();
        if (rawDataKey.length != this.getDataKeyLength()) {
            throw new InvalidKeyException("DataKey of incorrect length. Expected " + this.getDataKeyLength() + " but was " + rawDataKey.length);
        }
        byte[] rawEncKey = new byte[this.getKeyLength()];
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)dgst);
        hkdf.init((DerivationParameters)new HKDFParameters(rawDataKey, null, info.array()));
        hkdf.generateBytes(rawEncKey, 0, this.getKeyLength());
        return new SecretKeySpec(rawEncKey, this.getKeyAlgo());
    }

    static {
        BouncyCastleConfiguration.init();
        ID_MAPPING = new HashMap<Short, CryptoAlgorithm>();
        for (CryptoAlgorithm s : EnumSet.allOf(CryptoAlgorithm.class)) {
            ID_MAPPING.put(s.value_, s);
        }
    }
}

