/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import com.amazonaws.annotation.ThreadSafe;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

@ThreadSafe
public final class LRUCache<T> {
    private final Map<String, T> map;
    private final RemovalListener<T> listener;
    private final int maxSize;

    public LRUCache(int maxSize, RemovalListener<T> listener) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be at least 1");
        }
        this.maxSize = maxSize;
        this.listener = listener;
        this.map = Collections.synchronizedMap(new LRUHashMap(maxSize, listener));
    }

    public LRUCache(int maxSize) {
        this(maxSize, null);
    }

    public T add(String key, T value) {
        return this.map.put(key, value);
    }

    public T get(String key) {
        return this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void clear() {
        if (this.listener != null) {
            TreeSet<String> keys = new TreeSet<String>(this.map.keySet());
            for (String key : keys) {
                T val = this.map.get(key);
                this.listener.onRemoval(new AbstractMap.SimpleImmutableEntry<String, T>(key, val));
                this.map.remove(key);
            }
        } else {
            this.map.clear();
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public static interface RemovalListener<T> {
        public void onRemoval(Map.Entry<String, T> var1);
    }

    private static class LRUHashMap<T>
    extends LinkedHashMap<String, T> {
        private final int maxSize;
        private final RemovalListener<T> listener;

        private LRUHashMap(int maxSize, RemovalListener<T> listener) {
            super(10, 0.75f, true);
            this.maxSize = maxSize;
            this.listener = listener;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
            if (this.size() > this.maxSize) {
                if (this.listener != null) {
                    this.listener.onRemoval(eldest);
                }
                return true;
            }
            return false;
        }
    }
}

