/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.IBinder;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferNetworkLossHandler;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Map;

public class TransferService
extends Service {
    private static final Log LOGGER = LogFactory.getLog(TransferService.class);
    static TransferNetworkLossHandler transferNetworkLossHandler;
    boolean isReceiverNotRegistered = true;
    private int ongoingNotificationId = 3462;
    private boolean removeNotification = true;
    private static final int ANDROID_OREO = 26;
    public static final String INTENT_KEY_NOTIFICATION = "notification";
    public static final String INTENT_KEY_NOTIFICATION_ID = "ongoing-notification-id";
    public static final String INTENT_KEY_REMOVE_NOTIFICATION = "remove-notification";

    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Can't bind to TransferService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate() {
        super.onCreate();
        LOGGER.info((Object)"Starting Transfer Service to listen for network connectivity changes.");
        transferNetworkLossHandler = TransferNetworkLossHandler.getInstance(this.getApplicationContext());
        TransferService transferService = this;
        synchronized (transferService) {
            if (this.isReceiverNotRegistered) {
                try {
                    LOGGER.info((Object)"Registering the network receiver");
                    this.registerReceiver(transferNetworkLossHandler, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    this.isReceiverNotRegistered = false;
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn((Object)"Ignoring the exception trying to register the receiver for connectivity change.");
                }
                catch (IllegalStateException ise) {
                    LOGGER.warn((Object)"Ignoring the leak in registering the receiver.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        TransferService transferService;
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                transferService = this;
                synchronized (transferService) {
                    Notification userProvidedNotification = (Notification)intent.getParcelableExtra(INTENT_KEY_NOTIFICATION);
                    if (userProvidedNotification != null) {
                        this.ongoingNotificationId = intent.getIntExtra(INTENT_KEY_NOTIFICATION_ID, this.ongoingNotificationId);
                        this.removeNotification = intent.getBooleanExtra(INTENT_KEY_REMOVE_NOTIFICATION, this.removeNotification);
                        LOGGER.info((Object)"Putting the service in Foreground state.");
                        if (Build.VERSION.SDK_INT >= 34) {
                            this.startForeground(this.ongoingNotificationId, userProvidedNotification, 1);
                        } else {
                            this.startForeground(this.ongoingNotificationId, userProvidedNotification);
                        }
                    } else {
                        LOGGER.error((Object)"No notification is passed in the intent. Unable to transition to foreground.");
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error in moving the service to foreground state: " + ex));
            }
        }
        transferService = this;
        synchronized (transferService) {
            if (this.isReceiverNotRegistered) {
                try {
                    LOGGER.info((Object)"Registering the network receiver");
                    this.registerReceiver(transferNetworkLossHandler, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    this.isReceiverNotRegistered = false;
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn((Object)"Ignoring the exception trying to register the receiver for connectivity change.");
                }
                catch (IllegalStateException ise) {
                    LOGGER.warn((Object)"Ignoring the leak in registering the receiver.");
                }
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        block11: {
            try {
                if (Build.VERSION.SDK_INT < 26) break block11;
                LOGGER.info((Object)"Moving the service out of the Foreground state.");
                TransferService transferService = this;
                synchronized (transferService) {
                    this.stopForeground(this.removeNotification);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error in moving the service out of the foreground state: " + ex));
            }
        }
        try {
            LOGGER.info((Object)"De-registering the network receiver.");
            TransferService ex = this;
            synchronized (ex) {
                if (!this.isReceiverNotRegistered) {
                    this.unregisterReceiver(transferNetworkLossHandler);
                    this.isReceiverNotRegistered = true;
                    transferNetworkLossHandler = null;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)"Exception trying to de-register the network receiver");
        }
        super.onDestroy();
    }

    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if ((this.getApplicationInfo().flags & 2) == 0) {
            return;
        }
        writer.printf("network status: %s\n", transferNetworkLossHandler.isNetworkConnected());
        Map<Integer, TransferRecord> transfers = TransferStatusUpdater.getInstance((Context)this).getTransfers();
        writer.printf("# of active transfers: %d\n", transfers.size());
        for (TransferRecord transfer : transfers.values()) {
            writer.printf("bucket: %s, key: %s, status: %s, total size: %d, current: %d\n", new Object[]{transfer.bucketName, transfer.key, transfer.state, transfer.bytesTotal, transfer.bytesCurrent});
        }
        writer.flush();
    }
}

