/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import java.security.Key;
import java.security.Provider;

@Deprecated
class S3KeyWrapScheme {
    static final S3KeyWrapScheme NONE = new S3KeyWrapScheme(){

        @Override
        String getKeyWrapAlgorithm(Key key, Provider provider) {
            return null;
        }

        @Override
        public String toString() {
            return "NONE";
        }
    };
    public static final String AES_WRAP = "AESWrap";
    public static final String RSA_ECB_OAEP_WITH_SHA256_AND_MGF1_PADDING = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    S3KeyWrapScheme() {
    }

    String getKeyWrapAlgorithm(Key key, Provider provider) {
        String algorithm = key.getAlgorithm();
        if ("AES".equals(algorithm)) {
            return AES_WRAP;
        }
        if ("RSA".equals(algorithm) && CryptoRuntime.isRsaKeyWrapAvailable(provider)) {
            return RSA_ECB_OAEP_WITH_SHA256_AND_MGF1_PADDING;
        }
        return null;
    }

    public String toString() {
        return "S3KeyWrapScheme";
    }
}

