/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AbortedException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferNetworkLossHandler;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityException;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadTask;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

class UploadPartTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(UploadPartTask.class);
    private static final int RETRY_COUNT = 3;
    private final UploadTask.UploadPartTaskMetadata uploadPartTaskMetadata;
    private final UploadPartTaskProgressListener uploadPartTaskProgressListener;
    private final UploadPartRequest uploadPartRequest;
    private final AmazonS3 s3;
    private final TransferDBUtil dbUtil;

    public UploadPartTask(UploadTask.UploadPartTaskMetadata uploadPartTaskMetadata, UploadTask.UploadTaskProgressListener uploadTaskProgressListener, UploadPartRequest uploadPartRequest, AmazonS3 s3, TransferDBUtil dbUtil) {
        this.uploadPartTaskMetadata = uploadPartTaskMetadata;
        this.uploadPartTaskProgressListener = new UploadPartTaskProgressListener(uploadTaskProgressListener);
        this.uploadPartRequest = uploadPartRequest;
        this.s3 = s3;
        this.dbUtil = dbUtil;
    }

    @Override
    public Boolean call() throws Exception {
        this.uploadPartTaskMetadata.state = TransferState.IN_PROGRESS;
        this.uploadPartRequest.setGeneralProgressListener(this.uploadPartTaskProgressListener);
        int retried = 1;
        while (true) {
            try {
                UploadPartResult putPartResult = this.s3.uploadPart(this.uploadPartRequest);
                this.setTaskState(TransferState.PART_COMPLETED);
                this.dbUtil.updateETag(this.uploadPartRequest.getId(), putPartResult.getETag());
                return true;
            }
            catch (AbortedException e) {
                LOGGER.debug((Object)"Upload part aborted.");
                this.resetProgress();
                return false;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unexpected error occurred: " + e));
                this.resetProgress();
                try {
                    if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                        LOGGER.info((Object)("Thread: [" + Thread.currentThread().getId() + "]: Network wasn't available."));
                        this.uploadPartTaskMetadata.state = TransferState.WAITING_FOR_NETWORK;
                        this.dbUtil.updateState(this.uploadPartRequest.getId(), TransferState.WAITING_FOR_NETWORK);
                        LOGGER.info((Object)"Network Connection Interrupted: Moving the TransferState to WAITING_FOR_NETWORK");
                        return false;
                    }
                }
                catch (TransferUtilityException transferUtilityException) {
                    LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
                }
                if (retried >= 3) {
                    this.setTaskState(TransferState.FAILED);
                    LOGGER.error((Object)"Encountered error uploading part ", (Throwable)e);
                    throw e;
                }
                long delayMs = this.exponentialBackoffWithJitter(retried);
                LOGGER.info((Object)("Retrying in " + delayMs + " ms."));
                TimeUnit.MILLISECONDS.sleep(delayMs);
                LOGGER.debug((Object)("Retry attempt: " + retried++), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void setTaskState(TransferState newState) {
        this.uploadPartTaskMetadata.state = newState;
        this.dbUtil.updateState(this.uploadPartRequest.getId(), newState);
    }

    private void resetProgress() {
        ProgressEvent resetEvent = new ProgressEvent(0L);
        resetEvent.setEventCode(32);
        this.uploadPartTaskProgressListener.progressChanged(resetEvent);
    }

    private long exponentialBackoffWithJitter(int retryAttempt) {
        long baseTimeMs = 1000L;
        long jitterFactor = 1000L;
        long delay = 1000L * (long)(1 << retryAttempt);
        long jitter = (long)(1000.0 * Math.random());
        return delay + jitter;
    }

    private class UploadPartTaskProgressListener
    implements ProgressListener {
        private final UploadTask.UploadTaskProgressListener uploadTaskProgressListener;
        private long bytesTransferredSoFar;

        public UploadPartTaskProgressListener(UploadTask.UploadTaskProgressListener progressListener) {
            this.uploadTaskProgressListener = progressListener;
        }

        public void progressChanged(ProgressEvent progressEvent) {
            if (32 == progressEvent.getEventCode()) {
                LOGGER.debug((Object)"Reset Event triggered. Resetting the bytesCurrent to 0.");
                this.bytesTransferredSoFar = 0L;
            } else {
                this.bytesTransferredSoFar += progressEvent.getBytesTransferred();
            }
            this.uploadTaskProgressListener.onProgressChanged(UploadPartTask.this.uploadPartRequest.getPartNumber(), this.bytesTransferredSoFar);
        }
    }
}

