/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.internal.MetricAware;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricFilterInputStream;
import com.amazonaws.metrics.ThroughputMetricType;
import com.amazonaws.services.s3.metrics.S3ServiceMetric;
import java.io.IOException;
import java.io.InputStream;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private boolean eof;

    public S3ObjectInputStream(InputStream in) {
        super((InputStream)(S3ObjectInputStream.wrapWithByteCounting(in) ? new MetricFilterInputStream((ThroughputMetricType)S3ServiceMetric.S3_DOWLOAD_THROUGHPUT, in) : in));
    }

    private static boolean wrapWithByteCounting(InputStream in) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (in instanceof MetricAware) {
            MetricAware aware = (MetricAware)in;
            return !aware.isMetricActivated();
        }
        return true;
    }

    public void abort() {
        this.doAbort();
    }

    private void doAbort() {
        try {
            this.close();
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)"FYI", (Throwable)e);
        }
    }

    public int available() throws IOException {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }

    public int read() throws IOException {
        int value = super.read();
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int value = super.read(b, off, len);
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    public void reset() throws IOException {
        super.reset();
        this.eof = false;
    }
}

