/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBBase;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.json.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TransferDBUtil {
    private static TransferDBBase transferDBBase;
    private final Map<Integer, Long> mapLastBytes;
    private final Map<Integer, Long> mapLastUploadTime;

    public TransferDBUtil(Context context) {
        if (transferDBBase == null) {
            transferDBBase = new TransferDBBase(context);
        }
        this.mapLastBytes = new HashMap<Integer, Long>();
        this.mapLastUploadTime = new HashMap<Integer, Long>();
    }

    public void closeDB() {
        if (transferDBBase != null) {
            transferDBBase.closeDBHelper();
        }
    }

    public Uri insertMultipartUploadRecord(String bucket, String key, File file, long fileOffset, int partNumber, String uploadId, long bytesTotal, int isLastPart) {
        ContentValues values = this.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, partNumber, uploadId, bytesTotal, isLastPart, new ObjectMetadata());
        return transferDBBase.insert(transferDBBase.getContentUri(), values);
    }

    public Uri insertSingleTransferRecord(TransferType type, String bucket, String key, File file, ObjectMetadata metadata) {
        ContentValues values = this.generateContentValuesForSinglePartTransfer(type, bucket, key, file, metadata);
        return transferDBBase.insert(transferDBBase.getContentUri(), values);
    }

    public Uri insertSingleTransferRecord(TransferType type, String bucket, String key, File file) {
        return this.insertSingleTransferRecord(type, bucket, key, file, new ObjectMetadata());
    }

    public int bulkInsertTransferRecords(ContentValues[] valuesArray) {
        return transferDBBase.bulkInsert(transferDBBase.getContentUri(), valuesArray);
    }

    public int updateBytesTransferred(int id, long bytes, boolean forceUpdate) {
        long timeInMillis = System.currentTimeMillis();
        if (forceUpdate || !this.mapLastBytes.containsKey(id) || !this.mapLastUploadTime.containsKey(id) || bytes - this.mapLastBytes.get(id) > 10240L && timeInMillis - this.mapLastUploadTime.get(id) > 1000L) {
            ContentValues values = new ContentValues();
            values.put("bytes_current", Long.valueOf(bytes));
            this.mapLastBytes.put(id, bytes);
            this.mapLastUploadTime.put(id, timeInMillis);
            return transferDBBase.update(this.getRecordUri(id), values, null, null);
        }
        return 0;
    }

    public int updateBytesTotalForDownload(int id, long bytes) {
        ContentValues values = new ContentValues();
        values.put("bytes_total", Long.valueOf(bytes));
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateState(int id, TransferState state) {
        ContentValues values = new ContentValues();
        values.put("state", state.toString());
        if (TransferState.FAILED.equals((Object)state)) {
            return transferDBBase.update(this.getRecordUri(id), values, "state not in (?,?,?,?,?) ", new String[]{TransferState.COMPLETED.toString(), TransferState.PENDING_NETWORK_DISCONNECT.toString(), TransferState.PAUSED.toString(), TransferState.CANCELED.toString(), TransferState.WAITING_FOR_NETWORK.toString()});
        }
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateStateAndNotifyUpdate(int id, TransferState state) {
        ContentValues values = new ContentValues();
        values.put("state", state.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "_id=" + id, null);
    }

    public int updateMultipartId(int id, String multipartId) {
        ContentValues values = new ContentValues();
        values.put("multipart_id", multipartId);
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateETag(int id, String etag) {
        ContentValues values = new ContentValues();
        values.put("etag", etag);
        return transferDBBase.update(this.getRecordUri(id), values, null, null);
    }

    public int updateNetworkDisconnected() {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PENDING_NETWORK_DISCONNECT.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "state in (?,?,?)", new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString()});
    }

    public int updateNetworkConnected() {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.RESUMED_WAITING.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "state in (?,?)", new String[]{TransferState.PENDING_NETWORK_DISCONNECT.toString(), TransferState.WAITING_FOR_NETWORK.toString()});
    }

    public int setAllRunningRecordsToPausedBeforeShutdownService() {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PAUSED.toString());
        return transferDBBase.update(transferDBBase.getContentUri(), values, "state in (?,?,?,?)", new String[]{TransferState.IN_PROGRESS.toString(), TransferState.PENDING_PAUSE.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString()});
    }

    public int pauseAllWithType(TransferType type) {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PENDING_PAUSE.toString());
        String selection = null;
        String[] selectionArgs = null;
        if (type == TransferType.ANY) {
            selection = "state in (?,?,?)";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString()};
        } else {
            selection = "state in (?,?,?) and type=?";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString(), type.toString()};
        }
        return transferDBBase.update(transferDBBase.getContentUri(), values, selection, selectionArgs);
    }

    public int cancelAllWithType(TransferType type) {
        ContentValues values = new ContentValues();
        values.put("state", TransferState.PENDING_CANCEL.toString());
        String selection = null;
        String[] selectionArgs = null;
        if (type == TransferType.ANY) {
            selection = "state in (?,?,?,?,?)";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString(), TransferState.PAUSED.toString(), TransferState.WAITING_FOR_NETWORK.toString()};
        } else {
            selection = "state in (?,?,?,?,?) and type=?";
            selectionArgs = new String[]{TransferState.IN_PROGRESS.toString(), TransferState.RESUMED_WAITING.toString(), TransferState.WAITING.toString(), TransferState.PAUSED.toString(), TransferState.WAITING_FOR_NETWORK.toString(), type.toString()};
        }
        return transferDBBase.update(transferDBBase.getContentUri(), values, selection, selectionArgs);
    }

    public Cursor queryAllTransfersWithType(TransferType type) {
        if (type == TransferType.ANY) {
            return transferDBBase.query(transferDBBase.getContentUri(), null, null, null, null);
        }
        return transferDBBase.query(transferDBBase.getContentUri(), null, "type=?", new String[]{type.toString()}, null);
    }

    public Cursor queryTransfersWithTypeAndState(TransferType type, TransferState state) {
        if (type == TransferType.ANY) {
            return transferDBBase.query(this.getStateUri(state), null, null, null, null);
        }
        return transferDBBase.query(this.getStateUri(state), null, "type=?", new String[]{type.toString()}, null);
    }

    public Cursor queryTransferById(int id) {
        return transferDBBase.query(this.getRecordUri(id), null, null, null, null);
    }

    public long queryBytesTransferredByMainUploadId(int mainUploadId) {
        Cursor c = transferDBBase.query(this.getPartUri(mainUploadId), null, null, null, null);
        long bytesTotal = 0L;
        while (c.moveToNext()) {
            String state = c.getString(c.getColumnIndexOrThrow("state"));
            if (!TransferState.PART_COMPLETED.equals((Object)TransferState.getState(state))) continue;
            bytesTotal += c.getLong(c.getColumnIndexOrThrow("bytes_total"));
        }
        c.close();
        return bytesTotal;
    }

    public int deleteTransferRecords(int id) {
        return transferDBBase.delete(this.getRecordUri(id), null, null);
    }

    public List<PartETag> queryPartETagsOfUpload(int mainUploadId) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        Cursor c = transferDBBase.query(this.getPartUri(mainUploadId), null, null, null, null);
        int partNum = 0;
        String eTag = null;
        while (c.moveToNext()) {
            partNum = c.getInt(c.getColumnIndexOrThrow("part_num"));
            eTag = c.getString(c.getColumnIndexOrThrow("etag"));
            partETags.add(new PartETag(partNum, eTag));
        }
        c.close();
        return partETags;
    }

    public List<UploadPartRequest> getNonCompletedPartRequestsFromDB(int mainUploadId, String multipartId) {
        ArrayList<UploadPartRequest> list = new ArrayList<UploadPartRequest>();
        Cursor c = transferDBBase.query(this.getPartUri(mainUploadId), null, null, null, null);
        while (c.moveToNext()) {
            if (TransferState.PART_COMPLETED.equals((Object)TransferState.getState(c.getString(c.getColumnIndexOrThrow("state"))))) continue;
            UploadPartRequest putPartRequest = new UploadPartRequest().withId(c.getInt(c.getColumnIndexOrThrow("_id"))).withMainUploadId(c.getInt(c.getColumnIndexOrThrow("main_upload_id"))).withBucketName(c.getString(c.getColumnIndexOrThrow("bucket_name"))).withKey(c.getString(c.getColumnIndexOrThrow("key"))).withUploadId(multipartId).withFile(new File(c.getString(c.getColumnIndexOrThrow("file")))).withFileOffset(c.getLong(c.getColumnIndexOrThrow("file_offset"))).withPartNumber(c.getInt(c.getColumnIndexOrThrow("part_num"))).withPartSize(c.getLong(c.getColumnIndexOrThrow("bytes_total"))).withLastPart(1 == c.getInt(c.getColumnIndexOrThrow("is_last_part")));
            list.add(putPartRequest);
        }
        c.close();
        return list;
    }

    public ContentValues generateContentValuesForMultiPartUpload(String bucket, String key, File file, long fileOffset, int partNumber, String uploadId, long bytesTotal, int isLastPart, ObjectMetadata metadata) {
        ContentValues values = new ContentValues();
        values.put("type", TransferType.UPLOAD.toString());
        values.put("state", TransferState.WAITING.toString());
        values.put("bucket_name", bucket);
        values.put("key", key);
        values.put("file", file.getAbsolutePath());
        values.put("bytes_current", Long.valueOf(0L));
        values.put("bytes_total", Long.valueOf(bytesTotal));
        values.put("is_multipart", Integer.valueOf(1));
        values.put("part_num", Integer.valueOf(partNumber));
        values.put("file_offset", Long.valueOf(fileOffset));
        values.put("multipart_id", uploadId);
        values.put("is_last_part", Integer.valueOf(isLastPart));
        values.put("is_encrypted", Integer.valueOf(0));
        values.putAll(this.generateContentValuesForObjectMetadata(metadata));
        return values;
    }

    private ContentValues generateContentValuesForObjectMetadata(ObjectMetadata metadata) {
        ContentValues values = new ContentValues();
        values.put("user_metadata", JsonUtils.mapToString(metadata.getUserMetadata()));
        values.put("header_content_type", metadata.getContentType());
        values.put("header_content_encoding", metadata.getContentEncoding());
        values.put("header_cache_control", metadata.getCacheControl());
        values.put("content_md5", metadata.getContentMD5());
        values.put("header_content_disposition", metadata.getContentDisposition());
        values.put("sse_algorithm", metadata.getSSEAlgorithm());
        values.put("expiration_time_rule_id", metadata.getExpirationTimeRuleId());
        if (metadata.getHttpExpiresDate() != null) {
            values.put("http_expires_date", String.valueOf(metadata.getHttpExpiresDate().getTime()));
        }
        return values;
    }

    private ContentValues generateContentValuesForSinglePartTransfer(TransferType type, String bucket, String key, File file, ObjectMetadata metadata) {
        ContentValues values = new ContentValues();
        values.put("type", type.toString());
        values.put("state", TransferState.WAITING.toString());
        values.put("bucket_name", bucket);
        values.put("key", key);
        values.put("file", file.getAbsolutePath());
        values.put("bytes_current", Long.valueOf(0L));
        if (type.equals((Object)TransferType.UPLOAD)) {
            values.put("bytes_total", Long.valueOf(file == null ? 0L : file.length()));
        }
        values.put("is_multipart", Integer.valueOf(0));
        values.put("part_num", Integer.valueOf(0));
        values.put("is_encrypted", Integer.valueOf(0));
        values.putAll(this.generateContentValuesForObjectMetadata(metadata));
        return values;
    }

    public Uri getContentUri() {
        return transferDBBase.getContentUri();
    }

    public Uri getRecordUri(int id) {
        return Uri.parse((String)(transferDBBase.getContentUri() + "/" + id));
    }

    public Uri getPartUri(int mainUploadId) {
        return Uri.parse((String)(transferDBBase.getContentUri() + "/part/" + mainUploadId));
    }

    public Uri getStateUri(TransferState state) {
        return Uri.parse((String)(transferDBBase.getContentUri() + "/state/" + state.toString()));
    }
}

