/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

public class S3ClientOptions {
    public static final boolean DEFAULT_SKIP_CONTENT_MD5_CHECK = false;
    public static final boolean DEFAULT_PATH_STYLE_ACCESS = false;
    public static final boolean DEFAULT_CHUNKED_ENCODING_DISABLED = false;
    public static final boolean DEFAULT_PAYLOAD_SIGNING_ENABLED = false;
    public static final boolean DEFAULT_ACCELERATE_MODE_ENABLED = false;
    public static final boolean DEFAULT_DUALSTACK_ENABLED = false;
    private boolean skipContentMd5Check;
    private boolean pathStyleAccess;
    private final boolean chunkedEncodingDisabled;
    private final boolean accelerateModeEnabled;
    private final boolean payloadSigningEnabled;
    private final boolean dualstackEnabled;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public S3ClientOptions() {
        this.skipContentMd5Check = false;
        this.pathStyleAccess = false;
        this.chunkedEncodingDisabled = false;
        this.accelerateModeEnabled = false;
        this.payloadSigningEnabled = false;
        this.dualstackEnabled = false;
    }

    @Deprecated
    public S3ClientOptions(S3ClientOptions other) {
        this.skipContentMd5Check = other.skipContentMd5Check;
        this.pathStyleAccess = other.pathStyleAccess;
        this.chunkedEncodingDisabled = other.chunkedEncodingDisabled;
        this.accelerateModeEnabled = other.accelerateModeEnabled;
        this.payloadSigningEnabled = other.payloadSigningEnabled;
        this.dualstackEnabled = other.dualstackEnabled;
    }

    private S3ClientOptions(boolean skipContentMd5Check, boolean pathStyleAccess, boolean chunkedEncodingDisabled, boolean accelerateModeEnabled, boolean payloadSigningEnabled, boolean dualstackEnabled) {
        this.skipContentMd5Check = skipContentMd5Check;
        this.pathStyleAccess = pathStyleAccess;
        this.chunkedEncodingDisabled = chunkedEncodingDisabled;
        this.accelerateModeEnabled = accelerateModeEnabled;
        this.payloadSigningEnabled = payloadSigningEnabled;
        this.dualstackEnabled = dualstackEnabled;
    }

    public boolean isContentMd5CheckSkipped() {
        return this.skipContentMd5Check;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    public boolean isChunkedEncodingDisabled() {
        return this.chunkedEncodingDisabled;
    }

    public boolean isAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public boolean isPayloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public void skipContentMd5Check(boolean skipContentMd5Check) {
        this.skipContentMd5Check = skipContentMd5Check;
    }

    @Deprecated
    public void setPathStyleAccess(boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
    }

    public boolean isDualstackEnabled() {
        return this.dualstackEnabled;
    }

    @Deprecated
    public S3ClientOptions withPathStyleAccess(boolean pathStyleAccess) {
        this.setPathStyleAccess(pathStyleAccess);
        return this;
    }

    public static final class Builder {
        private boolean skipContentMd5Check = false;
        private boolean pathStyleAccess = false;
        private boolean chunkedEncodingDisabled = false;
        private boolean accelerateModeEnabled = false;
        private boolean payloadSigningEnabled = false;
        private boolean dualstackEnabled = false;

        private Builder() {
        }

        public S3ClientOptions build() {
            return new S3ClientOptions(this.skipContentMd5Check, this.pathStyleAccess, this.chunkedEncodingDisabled, this.accelerateModeEnabled, this.payloadSigningEnabled, this.dualstackEnabled);
        }

        public Builder skipContentMd5Check(boolean skipContentMd5Check) {
            this.skipContentMd5Check = skipContentMd5Check;
            return this;
        }

        public Builder setPathStyleAccess(boolean pathStyleAccess) {
            this.pathStyleAccess = pathStyleAccess;
            return this;
        }

        public Builder setAccelerateModeEnabled(boolean accelerateModeEnabled) {
            this.accelerateModeEnabled = accelerateModeEnabled;
            return this;
        }

        public Builder setPayloadSigningEnabled(boolean payloadSigningEnabled) {
            this.payloadSigningEnabled = payloadSigningEnabled;
            return this;
        }

        public Builder disableChunkedEncoding() {
            this.chunkedEncodingDisabled = true;
            return this;
        }

        public Builder enableDualstack() {
            this.dualstackEnabled = true;
            return this;
        }
    }
}

