/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import java.util.Map;

public class HostedUIOptions {
    private final Builder builder;

    HostedUIOptions(Builder builder) {
        this.builder = builder;
    }

    public String[] getScopes() {
        return this.builder.scopes;
    }

    public String getIdentityProvider() {
        return this.builder.identityProvider;
    }

    public String getIdpIdentifier() {
        return this.builder.idpIdentifier;
    }

    public Boolean getFederationEnabled() {
        return this.builder.disableFederation;
    }

    public String getFederationProviderName() {
        return this.builder.federationProviderName;
    }

    public Map<String, String> getSignInQueryParameters() {
        return this.builder.signInQueryParameters;
    }

    public Map<String, String> getSignOutQueryParameters() {
        return this.builder.signOutQueryParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String[] scopes;
        private String identityProvider;
        private String idpIdentifier;
        private Boolean disableFederation;
        private String federationProviderName;
        private Map<String, String> signInQueryParameters;
        private Map<String, String> signOutQueryParameters;

        public Builder signInQueryParameters(Map<String, String> signInQueryParameters) {
            this.signInQueryParameters = signInQueryParameters;
            return this;
        }

        public Builder signOutQueryParameters(Map<String, String> signOutQueryParameters) {
            this.signOutQueryParameters = signOutQueryParameters;
            return this;
        }

        public Builder scopes(String ... scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder identityProvider(String identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public Builder idpIdentifier(String idpIdentifier) {
            this.idpIdentifier = idpIdentifier;
            return this;
        }

        public Builder disableFederation(boolean disableFederation) {
            this.disableFederation = disableFederation;
            return this;
        }

        public Builder federationProviderName(String federationProviderName) {
            this.federationProviderName = federationProviderName;
            return this;
        }

        public HostedUIOptions build() {
            return new HostedUIOptions(this);
        }
    }
}

