/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import com.amazonaws.mobile.client.AWSMobileClient;
import com.amazonaws.mobile.client.Callback;
import com.amazonaws.mobile.client.internal.ReturningRunnable;
import com.amazonaws.mobile.client.results.Device;
import com.amazonaws.mobile.client.results.ListDevicesResult;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoDevice;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceRememberedStatusType;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceType;
import com.amazonaws.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetDeviceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetDeviceResult;
import com.amazonaws.services.cognitoidentityprovider.model.ListDevicesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import java.util.ArrayList;
import java.util.HashMap;

public class DeviceOperations {
    private final AWSMobileClient mobileClient;
    private final AmazonCognitoIdentityProvider userpoolLL;

    DeviceOperations(AWSMobileClient mobileClient, AmazonCognitoIdentityProvider userpoolLL) {
        this.mobileClient = mobileClient;
        this.userpoolLL = userpoolLL;
    }

    public Device get() throws Exception {
        return this._getDevice(null).await();
    }

    public void get(Callback<Device> callback) {
        this._getDevice(null).async(callback);
    }

    public Device get(String deviceId) throws Exception {
        return this._getDevice(deviceId).await();
    }

    public void get(String deviceId, Callback<Device> callback) {
        this._getDevice(deviceId).async(callback);
    }

    private ReturningRunnable<Device> _getDevice(final String deviceKey) {
        return new ReturningRunnable<Device>(){

            @Override
            public Device run() throws Exception {
                CognitoDevice cognitoDevice = DeviceOperations.this.getCognitoDevice(deviceKey);
                GetDeviceRequest getDeviceRequest = new GetDeviceRequest();
                getDeviceRequest.setAccessToken(DeviceOperations.this.mobileClient.getTokens().getAccessToken().getTokenString());
                getDeviceRequest.setDeviceKey(cognitoDevice.getDeviceKey());
                GetDeviceResult getDeviceResult = DeviceOperations.this.userpoolLL.getDevice(getDeviceRequest);
                return DeviceOperations.this.marshallDeviceTypeToDevice(getDeviceResult.getDevice());
            }
        };
    }

    public ListDevicesResult list() throws Exception {
        return this._listDevices(60, null).await();
    }

    public void list(Callback<ListDevicesResult> callback) {
        this._listDevices(60, null).async(callback);
    }

    public ListDevicesResult list(Integer limit, String paginationToken) throws Exception {
        return this._listDevices(limit, paginationToken).await();
    }

    public void list(Integer limit, String paginationToken, Callback<ListDevicesResult> callback) {
        this._listDevices(limit, paginationToken).async(callback);
    }

    private ReturningRunnable<ListDevicesResult> _listDevices(final Integer limit, final String paginationToken) {
        return new ReturningRunnable<ListDevicesResult>(){

            @Override
            public ListDevicesResult run() throws Exception {
                ListDevicesRequest listDevicesRequest = new ListDevicesRequest();
                listDevicesRequest.setAccessToken(DeviceOperations.this.mobileClient.getTokens().getAccessToken().getTokenString());
                listDevicesRequest.setLimit(limit);
                listDevicesRequest.setPaginationToken(paginationToken);
                com.amazonaws.services.cognitoidentityprovider.model.ListDevicesResult listDevicesResult = DeviceOperations.this.userpoolLL.listDevices(listDevicesRequest);
                ArrayList<Device> devices = new ArrayList<Device>(limit);
                for (DeviceType deviceType : listDevicesResult.getDevices()) {
                    devices.add(DeviceOperations.this.marshallDeviceTypeToDevice(deviceType));
                }
                return new ListDevicesResult(devices, listDevicesResult.getPaginationToken());
            }
        };
    }

    private Device marshallDeviceTypeToDevice(DeviceType deviceType) {
        HashMap<String, String> deviceAttributes = new HashMap<String, String>();
        for (AttributeType attributeType : deviceType.getDeviceAttributes()) {
            deviceAttributes.put(attributeType.getName(), attributeType.getValue());
        }
        return new Device(deviceType.getDeviceKey(), deviceAttributes, deviceType.getDeviceCreateDate(), deviceType.getDeviceLastModifiedDate(), deviceType.getDeviceLastAuthenticatedDate());
    }

    public void updateStatus(boolean rememberDevice) throws Exception {
        this._rememberDevice(null, rememberDevice).await();
    }

    public void updateStatus(boolean rememberDevice, Callback<Void> callback) {
        this._rememberDevice(null, rememberDevice).async(callback);
    }

    public void updateStatus(String deviceKey, boolean rememberDevice) throws Exception {
        this._rememberDevice(deviceKey, rememberDevice).await();
    }

    public void updateStatus(String deviceKey, boolean rememberDevice, Callback<Void> callback) {
        this._rememberDevice(deviceKey, rememberDevice).async(callback);
    }

    private ReturningRunnable<Void> _rememberDevice(final String deviceKey, final boolean rememberDevice) {
        return new ReturningRunnable<Void>(){

            @Override
            public Void run() throws Exception {
                CognitoDevice cognitoDevice = DeviceOperations.this.getCognitoDevice(deviceKey);
                UpdateDeviceStatusRequest updateDeviceStatusRequest = new UpdateDeviceStatusRequest().withAccessToken(DeviceOperations.this.mobileClient.getTokens().getAccessToken().getTokenString()).withDeviceKey(cognitoDevice.getDeviceKey()).withDeviceRememberedStatus(rememberDevice ? DeviceRememberedStatusType.Remembered : DeviceRememberedStatusType.Not_remembered);
                DeviceOperations.this.userpoolLL.updateDeviceStatus(updateDeviceStatusRequest);
                return null;
            }
        };
    }

    public void forget() throws Exception {
        this._forgetDevice(null).await();
    }

    public void forget(Callback<Void> callback) {
        this._forgetDevice(null).async(callback);
    }

    public void forget(String deviceKey) throws Exception {
        this._forgetDevice(deviceKey).await();
    }

    public void forget(String deviceKey, Callback<Void> callback) {
        this._forgetDevice(deviceKey).async(callback);
    }

    private ReturningRunnable<Void> _forgetDevice(final String deviceKey) {
        return new ReturningRunnable<Void>(){

            @Override
            public Void run() throws Exception {
                CognitoDevice cognitoDevice = DeviceOperations.this.getCognitoDevice(deviceKey);
                ForgetDeviceRequest forgetDeviceRequest = new ForgetDeviceRequest().withAccessToken(DeviceOperations.this.mobileClient.getTokens().getAccessToken().getTokenString()).withDeviceKey(cognitoDevice.getDeviceKey());
                DeviceOperations.this.userpoolLL.forgetDevice(forgetDeviceRequest);
                return null;
            }
        };
    }

    private CognitoDevice getCognitoDevice(String deviceKey) {
        return new CognitoDevice(deviceKey != null ? deviceKey : this.mobileClient.userpool.getCurrentUser().thisDevice().getDeviceKey(), null, null, null, null, this.mobileClient.userpool.getCurrentUser(), this.mobileClient.mContext);
    }
}

