/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client.internal.oauth2;

import com.amazonaws.mobile.client.internal.oauth2.OAuth2Constants;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Exception;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Tokens;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthClientException;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthServiceException;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

class HTTPUtil {
    HTTPUtil() {
    }

    public static String httpPost(URL uri, Map<String, String> headerParams, Map<String, String> bodyParams, String userAgentOverride) throws Exception {
        if (uri == null || bodyParams == null || bodyParams.size() < 1) {
            throw new AuthClientException("Invalid http request parameters");
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uri.openConnection();
        FilterOutputStream httpOutputStream = null;
        BufferedReader br = null;
        try {
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setDoOutput(true);
            for (Map.Entry<String, String> param : headerParams.entrySet()) {
                httpsURLConnection.addRequestProperty(param.getKey(), param.getValue());
            }
            httpsURLConnection.addRequestProperty("x-amz-user-agent", userAgentOverride != null ? userAgentOverride : "AWSMobileClient");
            httpsURLConnection.setRequestProperty("User-Agent", userAgentOverride != null ? userAgentOverride : httpsURLConnection.getRequestProperty("User-Agent") + " " + "AWSMobileClient");
            StringBuilder reqBuilder = new StringBuilder();
            int index = bodyParams.size();
            for (Map.Entry<String, String> param : bodyParams.entrySet()) {
                reqBuilder.append(URLEncoder.encode(param.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(param.getValue(), "UTF-8"));
                if (index-- <= 1) continue;
                reqBuilder.append('&');
            }
            String requestBody = reqBuilder.toString();
            httpOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
            ((DataOutputStream)httpOutputStream).writeBytes(requestBody);
            ((DataOutputStream)httpOutputStream).flush();
            Map<String, List<String>> respHeaders = httpsURLConnection.getHeaderFields();
            int responseCode = httpsURLConnection.getResponseCode();
            if (responseCode >= 200 && responseCode < 500) {
                String line;
                InputStream httpDataStream = responseCode < 400 ? httpsURLConnection.getInputStream() : httpsURLConnection.getErrorStream();
                br = new BufferedReader(new InputStreamReader(httpDataStream));
                StringBuilder responseOutput = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    responseOutput.append(line);
                }
                String string = responseOutput.toString();
                return string;
            }
            throw new AuthServiceException(httpsURLConnection.getResponseMessage());
        }
        finally {
            if (httpOutputStream != null) {
                httpOutputStream.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public static OAuth2Tokens parseHttpResponse(String responseStr) throws JSONException {
        if (responseStr == null || responseStr.isEmpty()) {
            throw new IllegalArgumentException("Invalid (null) response from Amazon Cognito Auth endpoint");
        }
        JSONObject responseJson = new JSONObject(responseStr);
        String error = responseJson.optString(OAuth2Constants.TokenResponseFields.ERROR.toString(), null);
        String errorDescription = responseJson.optString(OAuth2Constants.TokenResponseFields.ERROR_DESCRIPTION.toString(), null);
        String errorUri = responseJson.optString(OAuth2Constants.TokenResponseFields.ERROR_URI.toString(), null);
        if (error != null) {
            throw new OAuth2Exception("Failed to exchange code for tokens", error, errorDescription, errorUri);
        }
        String expires_in = responseJson.optString(OAuth2Constants.TokenResponseFields.EXPIRES_IN.toString());
        Long expiresIn = null;
        if (!StringUtils.isBlank((CharSequence)expires_in)) {
            expiresIn = Long.parseLong(expires_in);
        }
        return new OAuth2Tokens(responseJson.getString(OAuth2Constants.TokenResponseFields.ACCESS_TOKEN.toString()), responseJson.optString(OAuth2Constants.TokenResponseFields.ID_TOKEN.toString(), null), responseJson.optString(OAuth2Constants.TokenResponseFields.REFRESH_TOKEN.toString(), null), responseJson.getString(OAuth2Constants.TokenResponseFields.TOKEN_TYPE.toString()), expiresIn, System.currentTimeMillis() / 1000L, responseJson.optString("scopes", null));
    }
}

