/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.ListKeyRotationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListKeyRotationsRequestMarshaller
implements Marshaller<Request<ListKeyRotationsRequest>, ListKeyRotationsRequest> {
    public Request<ListKeyRotationsRequest> marshall(ListKeyRotationsRequest listKeyRotationsRequest) {
        if (listKeyRotationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListKeyRotationsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listKeyRotationsRequest, "AWSKMS");
        String target = "TrentService.ListKeyRotations";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listKeyRotationsRequest.getKeyId() != null) {
                String keyId = listKeyRotationsRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (listKeyRotationsRequest.getLimit() != null) {
                Integer limit = listKeyRotationsRequest.getLimit();
                jsonWriter.name("Limit");
                jsonWriter.value((Number)limit);
            }
            if (listKeyRotationsRequest.getMarker() != null) {
                String marker = listKeyRotationsRequest.getMarker();
                jsonWriter.name("Marker");
                jsonWriter.value(marker);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

