/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.services.kms.model.GrantListEntry;
import com.amazonaws.services.kms.model.transform.GrantConstraintsJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class GrantListEntryJsonMarshaller {
    private static GrantListEntryJsonMarshaller instance;

    GrantListEntryJsonMarshaller() {
    }

    public void marshall(GrantListEntry grantListEntry, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (grantListEntry.getKeyId() != null) {
            String keyId = grantListEntry.getKeyId();
            jsonWriter.name("KeyId");
            jsonWriter.value(keyId);
        }
        if (grantListEntry.getGrantId() != null) {
            String grantId = grantListEntry.getGrantId();
            jsonWriter.name("GrantId");
            jsonWriter.value(grantId);
        }
        if (grantListEntry.getName() != null) {
            String name = grantListEntry.getName();
            jsonWriter.name("Name");
            jsonWriter.value(name);
        }
        if (grantListEntry.getCreationDate() != null) {
            Date creationDate = grantListEntry.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (grantListEntry.getGranteePrincipal() != null) {
            String granteePrincipal = grantListEntry.getGranteePrincipal();
            jsonWriter.name("GranteePrincipal");
            jsonWriter.value(granteePrincipal);
        }
        if (grantListEntry.getRetiringPrincipal() != null) {
            String retiringPrincipal = grantListEntry.getRetiringPrincipal();
            jsonWriter.name("RetiringPrincipal");
            jsonWriter.value(retiringPrincipal);
        }
        if (grantListEntry.getIssuingAccount() != null) {
            String issuingAccount = grantListEntry.getIssuingAccount();
            jsonWriter.name("IssuingAccount");
            jsonWriter.value(issuingAccount);
        }
        if (grantListEntry.getOperations() != null) {
            List<String> operations = grantListEntry.getOperations();
            jsonWriter.name("Operations");
            jsonWriter.beginArray();
            for (String operationsItem : operations) {
                if (operationsItem == null) continue;
                jsonWriter.value(operationsItem);
            }
            jsonWriter.endArray();
        }
        if (grantListEntry.getConstraints() != null) {
            GrantConstraints constraints = grantListEntry.getConstraints();
            jsonWriter.name("Constraints");
            GrantConstraintsJsonMarshaller.getInstance().marshall(constraints, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static GrantListEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GrantListEntryJsonMarshaller();
        }
        return instance;
    }
}

