/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.CreateGrantRequest;
import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.services.kms.model.transform.GrantConstraintsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateGrantRequestMarshaller
implements Marshaller<Request<CreateGrantRequest>, CreateGrantRequest> {
    public Request<CreateGrantRequest> marshall(CreateGrantRequest createGrantRequest) {
        if (createGrantRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateGrantRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGrantRequest, "AWSKMS");
        String target = "TrentService.CreateGrant";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createGrantRequest.getKeyId() != null) {
                String keyId = createGrantRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (createGrantRequest.getGranteePrincipal() != null) {
                String granteePrincipal = createGrantRequest.getGranteePrincipal();
                jsonWriter.name("GranteePrincipal");
                jsonWriter.value(granteePrincipal);
            }
            if (createGrantRequest.getRetiringPrincipal() != null) {
                String retiringPrincipal = createGrantRequest.getRetiringPrincipal();
                jsonWriter.name("RetiringPrincipal");
                jsonWriter.value(retiringPrincipal);
            }
            if (createGrantRequest.getOperations() != null) {
                List<String> operations = createGrantRequest.getOperations();
                jsonWriter.name("Operations");
                jsonWriter.beginArray();
                for (String operationsItem : operations) {
                    if (operationsItem == null) continue;
                    jsonWriter.value(operationsItem);
                }
                jsonWriter.endArray();
            }
            if (createGrantRequest.getConstraints() != null) {
                GrantConstraints constraints = createGrantRequest.getConstraints();
                jsonWriter.name("Constraints");
                GrantConstraintsJsonMarshaller.getInstance().marshall(constraints, jsonWriter);
            }
            if (createGrantRequest.getGrantTokens() != null) {
                List<String> grantTokens = createGrantRequest.getGrantTokens();
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensItem : grantTokens) {
                    if (grantTokensItem == null) continue;
                    jsonWriter.value(grantTokensItem);
                }
                jsonWriter.endArray();
            }
            if (createGrantRequest.getName() != null) {
                String name = createGrantRequest.getName();
                jsonWriter.name("Name");
                jsonWriter.value(name);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

