/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class GenerateDataKeyWithoutPlaintextRequestMarshaller
implements Marshaller<Request<GenerateDataKeyWithoutPlaintextRequest>, GenerateDataKeyWithoutPlaintextRequest> {
    public Request<GenerateDataKeyWithoutPlaintextRequest> marshall(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        if (generateDataKeyWithoutPlaintextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)generateDataKeyWithoutPlaintextRequest, "AWSKMS");
        String target = "TrentService.GenerateDataKeyWithoutPlaintext";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (generateDataKeyWithoutPlaintextRequest.getKeyId() != null) {
                jsonWriter.name("KeyId").value(generateDataKeyWithoutPlaintextRequest.getKeyId());
            }
            if (generateDataKeyWithoutPlaintextRequest.getEncryptionContext() != null) {
                jsonWriter.name("EncryptionContext");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> encryptionContextListValue : generateDataKeyWithoutPlaintextRequest.getEncryptionContext().entrySet()) {
                    if (encryptionContextListValue.getValue() == null) continue;
                    jsonWriter.name(encryptionContextListValue.getKey());
                    jsonWriter.value((String)encryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (generateDataKeyWithoutPlaintextRequest.getKeySpec() != null) {
                jsonWriter.name("KeySpec").value(generateDataKeyWithoutPlaintextRequest.getKeySpec());
            }
            if (generateDataKeyWithoutPlaintextRequest.getNumberOfBytes() != null) {
                jsonWriter.name("NumberOfBytes").value((Number)generateDataKeyWithoutPlaintextRequest.getNumberOfBytes());
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)generateDataKeyWithoutPlaintextRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

