/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetDataEndpointRequestMarshaller
implements Marshaller<Request<GetDataEndpointRequest>, GetDataEndpointRequest> {
    public Request<GetDataEndpointRequest> marshall(GetDataEndpointRequest getDataEndpointRequest) {
        if (getDataEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetDataEndpointRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDataEndpointRequest, "AWSKinesisVideo");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/getDataEndpoint";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getDataEndpointRequest.getStreamName() != null) {
                String streamName = getDataEndpointRequest.getStreamName();
                jsonWriter.name("StreamName");
                jsonWriter.value(streamName);
            }
            if (getDataEndpointRequest.getStreamARN() != null) {
                String streamARN = getDataEndpointRequest.getStreamARN();
                jsonWriter.name("StreamARN");
                jsonWriter.value(streamARN);
            }
            if (getDataEndpointRequest.getAPIName() != null) {
                String aPIName = getDataEndpointRequest.getAPIName();
                jsonWriter.name("APIName");
                jsonWriter.value(aPIName);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

