/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

import com.amazonaws.services.kinesisvideo.model.ChannelRole;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SingleMasterChannelEndpointConfiguration
implements Serializable {
    private List<String> protocols = new ArrayList<String>();
    private String role;

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new ArrayList<String>(protocols);
    }

    public SingleMasterChannelEndpointConfiguration withProtocols(String ... protocols) {
        if (this.getProtocols() == null) {
            this.protocols = new ArrayList<String>(protocols.length);
        }
        for (String value : protocols) {
            this.protocols.add(value);
        }
        return this;
    }

    public SingleMasterChannelEndpointConfiguration withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public SingleMasterChannelEndpointConfiguration withRole(String role) {
        this.role = role;
        return this;
    }

    public void setRole(ChannelRole role) {
        this.role = role.toString();
    }

    public SingleMasterChannelEndpointConfiguration withRole(ChannelRole role) {
        this.role = role.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtocols() != null) {
            sb.append("Protocols: " + this.getProtocols() + ",");
        }
        if (this.getRole() != null) {
            sb.append("Role: " + this.getRole());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMasterChannelEndpointConfiguration)) {
            return false;
        }
        SingleMasterChannelEndpointConfiguration other = (SingleMasterChannelEndpointConfiguration)obj;
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        if (other.getProtocols() != null && !other.getProtocols().equals(this.getProtocols())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        return other.getRole() == null || other.getRole().equals(this.getRole());
    }
}

