/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.util;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import com.amazonaws.mobileconnectors.kinesisvideo.data.MimeType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class VideoEncoderUtils {
    private static final String SOFTWARE_ENCODER_PREFIX = "OMX.google.";

    public static List<MimeType> getSupportedMimeTypes() {
        EnumSet<MimeType> suportedMimeTypes = EnumSet.noneOf(MimeType.class);
        List<MediaCodecInfo> encoders = VideoEncoderUtils.getSystemSupportedEncoders();
        for (MimeType mimeType : MimeType.values()) {
            for (MediaCodecInfo encoder : encoders) {
                if (!VideoEncoderUtils.supportsMimeAndYUV420(encoder, mimeType)) continue;
                suportedMimeTypes.add(mimeType);
            }
        }
        if (suportedMimeTypes.size() == 0) {
            throw new RuntimeException("Unable to find encoders for supported types and image format");
        }
        return new ArrayList<MimeType>(suportedMimeTypes);
    }

    private static boolean supportsMimeType(MediaCodecInfo encoder, MimeType mimeType) {
        for (String encoderSupportedMime : encoder.getSupportedTypes()) {
            if (!encoderSupportedMime.equalsIgnoreCase(mimeType.getMimeType())) continue;
            return true;
        }
        return false;
    }

    private static boolean supportsYUV420(MediaCodecInfo encoder, MimeType mimeType) {
        MediaCodecInfo.CodecCapabilities capabilities = encoder.getCapabilitiesForType(mimeType.getMimeType());
        for (int colorFormat : capabilities.colorFormats) {
            if (colorFormat != 2135033992) continue;
            return true;
        }
        return false;
    }

    public static List<MediaCodecInfo> getSystemSupportedEncoders() {
        MediaCodecList codecList = new MediaCodecList(0);
        ArrayList<MediaCodecInfo> codecInfoList = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo codecInfo : codecList.getCodecInfos()) {
            if (!codecInfo.isEncoder()) continue;
            codecInfoList.add(codecInfo);
        }
        return codecInfoList;
    }

    public static MediaCodecInfo getSupportedEncoder() {
        List<MediaCodecInfo> allSystemEncoders = VideoEncoderUtils.getSystemSupportedEncoders();
        ArrayList<MediaCodecInfo> supportedEncoders = new ArrayList<MediaCodecInfo>();
        ArrayList<MediaCodecInfo> supportedHardwareEncoders = new ArrayList<MediaCodecInfo>();
        for (MimeType mimeType : MimeType.values()) {
            for (MediaCodecInfo encoder : allSystemEncoders) {
                if (!VideoEncoderUtils.supportsMimeAndYUV420(encoder, mimeType)) continue;
                supportedEncoders.add(encoder);
                if (!VideoEncoderUtils.isHardwareAccelerated(encoder)) continue;
                supportedHardwareEncoders.add(encoder);
            }
        }
        if (supportedEncoders.size() == 0) {
            throw new RuntimeException("Could not found a supported encoder");
        }
        return VideoEncoderUtils.tryChooseBestEncoder(supportedEncoders, supportedHardwareEncoders);
    }

    public static boolean isHardwareAccelerated(MediaCodecInfo encoder) {
        return encoder.getName().startsWith(SOFTWARE_ENCODER_PREFIX);
    }

    private static MediaCodecInfo tryChooseBestEncoder(List<MediaCodecInfo> allSupportedEncoders, List<MediaCodecInfo> supportedHardwareEncoders) {
        MediaCodecInfo chosenEncoder = supportedHardwareEncoders.size() == 0 ? VideoEncoderUtils.tryFindH264Encoder(allSupportedEncoders) : VideoEncoderUtils.tryFindH264Encoder(supportedHardwareEncoders);
        return chosenEncoder == null ? allSupportedEncoders.get(0) : chosenEncoder;
    }

    private static MediaCodecInfo tryFindH264Encoder(List<MediaCodecInfo> supportedEncoders) {
        for (MediaCodecInfo encoder : supportedEncoders) {
            for (String encoderMimeType : encoder.getSupportedTypes()) {
                if (!MimeType.H264.getMimeType().equals(encoderMimeType)) continue;
                return encoder;
            }
        }
        return null;
    }

    private static boolean supportsMimeAndYUV420(MediaCodecInfo encoder, MimeType mimeType) {
        return VideoEncoderUtils.supportsMimeType(encoder, mimeType) && VideoEncoderUtils.supportsYUV420(encoder, mimeType);
    }
}

