/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.util;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraManager;
import android.util.Log;
import android.util.Size;
import com.amazonaws.kinesisvideo.client.KinesisVideoClient;
import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceConfiguration;
import com.amazonaws.mobileconnectors.kinesisvideo.util.CameraHardwareCapabilitiesHelper;
import com.amazonaws.mobileconnectors.kinesisvideo.util.DefaultCameraConfigurationHelper;
import java.util.ArrayList;
import java.util.List;

public class CameraUtils {
    private static final String TAG = CameraUtils.class.getSimpleName();

    public static List<Size> getSupportedResolutions(Context context, String cameraId) {
        return CameraHardwareCapabilitiesHelper.getSupportedResolutionsForYUV420_888(context, cameraId);
    }

    public static List<CameraMediaSourceConfiguration> getCameras(KinesisVideoClient kinesisVideoClient) {
        ArrayList<CameraMediaSourceConfiguration> cameras = new ArrayList<CameraMediaSourceConfiguration>();
        for (MediaSourceConfiguration.Builder<? extends MediaSourceConfiguration> mediaSourceConfiguration : kinesisVideoClient.listSupportedConfigurations()) {
            if (!(mediaSourceConfiguration instanceof CameraMediaSourceConfiguration.Builder)) continue;
            CameraMediaSourceConfiguration configuration = ((CameraMediaSourceConfiguration.Builder)mediaSourceConfiguration).build();
            cameras.add(configuration);
        }
        return cameras;
    }

    public static List<MediaSourceConfiguration.Builder<? extends MediaSourceConfiguration>> getSupportedCameraConfigrations(Context context) {
        ArrayList<MediaSourceConfiguration.Builder<? extends MediaSourceConfiguration>> cameraConfigurations = new ArrayList<MediaSourceConfiguration.Builder<? extends MediaSourceConfiguration>>();
        for (String cameraId : CameraUtils.getCameraIds(context)) {
            cameraConfigurations.add(DefaultCameraConfigurationHelper.getSupportedCameraConfiguration(context, cameraId));
        }
        return cameraConfigurations;
    }

    public static String[] getCameraIds(Context context) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            return cameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"unable to list cameras", (Throwable)e);
            throw new RuntimeException("unable to list cameras", e);
        }
    }

    private CameraUtils() {
    }
}

