/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.mediasource.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceSink;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducerStream;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;

public class ProducerStreamSink
implements MediaSourceSink {
    private final KinesisVideoProducerStream mProducerStream;

    public ProducerStreamSink(KinesisVideoProducerStream producerStream) {
        this.mProducerStream = producerStream;
    }

    @Override
    public void onFrame(@NonNull KinesisVideoFrame kinesisVideoFrame) throws KinesisVideoException {
        Preconditions.checkNotNull(kinesisVideoFrame);
        this.mProducerStream.putFrame(kinesisVideoFrame);
    }

    @Override
    public void onCodecPrivateData(@Nullable byte[] bytes) throws KinesisVideoException {
        this.mProducerStream.streamFormatChanged(bytes);
    }

    @Override
    public void onFragmentMetadata(@NonNull String metadataName, @NonNull String metadataValue, boolean persistent) throws KinesisVideoException {
        this.mProducerStream.putFragmentMetadata(metadataName, metadataValue, persistent);
    }

    @Override
    public KinesisVideoProducerStream getProducerStream() {
        return this.mProducerStream;
    }
}

