/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.mediasource.android;

import android.os.Parcel;
import android.os.Parcelable;
import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.producer.StreamInfo;

public class AndroidCameraMediaSourceConfiguration
extends CameraMediaSourceConfiguration
implements Parcelable {
    public static final Parcelable.Creator<AndroidCameraMediaSourceConfiguration> CREATOR = new Parcelable.Creator<AndroidCameraMediaSourceConfiguration>(){

        public AndroidCameraMediaSourceConfiguration createFromParcel(Parcel in) {
            return new AndroidCameraMediaSourceConfiguration(AndroidCameraMediaSourceConfiguration.readFromParcel(in));
        }

        public AndroidCameraMediaSourceConfiguration[] newArray(int size) {
            return new AndroidCameraMediaSourceConfiguration[size];
        }
    };

    public AndroidCameraMediaSourceConfiguration(CameraMediaSourceConfiguration.Builder builder) {
        super(builder);
    }

    public static CameraMediaSourceConfiguration.Builder builder() {
        return new CameraMediaSourceConfiguration.Builder();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.getCameraId());
        parcel.writeString(this.getOutputFileName());
        parcel.writeString(this.getEncoderMimeType());
        parcel.writeInt(this.getFrameRate());
        parcel.writeInt(this.getHorizontalResolution());
        parcel.writeInt(this.getVerticalResolution());
        parcel.writeInt(this.getCameraFacing());
        parcel.writeInt(this.getCameraOrientation());
        parcel.writeInt(this.getBitRate());
        parcel.writeInt(this.getRetentionPeriodInHours());
        parcel.writeString(String.valueOf(this.isEndcoderHardwareAccelerated()));
        parcel.writeLong(this.getTimeScale());
        parcel.writeInt(this.getNalAdaptationFlags().getIntValue());
        parcel.writeString(String.valueOf(this.getIsAbsoluteTimecode()));
        if (this.getCodecPrivateData() == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(this.getCodecPrivateData().length);
            parcel.writeByteArray(this.getCodecPrivateData());
        }
    }

    private static CameraMediaSourceConfiguration.Builder readFromParcel(Parcel parcel) {
        CameraMediaSourceConfiguration.Builder builder = new CameraMediaSourceConfiguration.Builder().withCameraId(parcel.readString()).withFileOutput(parcel.readString()).withEncodingMimeType(parcel.readString()).withFrameRate(parcel.readInt()).withHorizontalResolution(parcel.readInt()).withVerticalResolution(parcel.readInt()).withCameraFacing(parcel.readInt()).withCameraOrientation(parcel.readInt()).withEncodingBitRate(parcel.readInt()).withRetentionPeriodInHours(parcel.readInt()).withIsEncoderHardwareAccelerated(Boolean.parseBoolean(parcel.readString())).withFrameTimeScale(parcel.readLong()).withNalAdaptationFlags(StreamInfo.NalAdaptationFlags.getFlag(parcel.readInt())).withIsAbsoluteTimecode(Boolean.parseBoolean(parcel.readString()));
        int codecPrivateDataSize = parcel.readInt();
        if (codecPrivateDataSize > 0) {
            byte[] privateData = new byte[codecPrivateDataSize];
            parcel.readByteArray(privateData);
            builder.withCodecPrivateData(privateData);
        }
        return builder;
    }
}

