/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.encoding;

import android.media.Image;
import android.media.MediaCodec;
import android.util.Log;
import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;
import com.amazonaws.mobileconnectors.kinesisvideo.encoding.EncoderFactory;
import com.amazonaws.mobileconnectors.kinesisvideo.encoding.EncoderFrameSubmitter;
import com.amazonaws.mobileconnectors.kinesisvideo.util.FrameUtility;
import java.nio.ByteBuffer;

public class EncoderWrapper {
    private static final String TAG = EncoderWrapper.class.getSimpleName();
    private static final int TIMEOUT_USEC = 10000;
    private final CameraMediaSourceConfiguration mMediaSourceConfiguration;
    private MediaCodec mEncoder;
    private EncoderFrameSubmitter mEncoderFrameSubmitter;
    private long mLastRecordedFrameTimestamp = 0L;
    private MediaCodec.BufferInfo mBufferInfo;
    private CodecPrivateDataAvailableListener mCodecPrivateDataListener;
    private FrameAvailableListener mFrameAvailableListener;
    private boolean mIsStopped = false;
    private int mFrameIndex;
    private long mFragmentStart = 0L;

    public EncoderWrapper(CameraMediaSourceConfiguration mediaSourceConfiguration) {
        this.mMediaSourceConfiguration = mediaSourceConfiguration;
        this.initEncoder();
    }

    private void initEncoder() {
        this.mBufferInfo = new MediaCodec.BufferInfo();
        this.mEncoder = EncoderFactory.createConfiguredEncoder(this.mMediaSourceConfiguration);
        this.mEncoderFrameSubmitter = new EncoderFrameSubmitter(this.mEncoder);
        this.mEncoder.start();
    }

    public void setCodecPrivateDataAvailableListener(CodecPrivateDataAvailableListener listener) {
        this.mCodecPrivateDataListener = listener;
    }

    public void setEncodedFrameAvailableListener(FrameAvailableListener listener) {
        this.mFrameAvailableListener = listener;
    }

    public void encodeFrame(Image frameImageYUV420, boolean endOfStream) {
        if (this.mIsStopped) {
            Log.w((String)TAG, (String)"received a frame to encode after already stopped. returning");
            return;
        }
        Log.d((String)TAG, (String)("encoding frame" + EncoderWrapper.threadId()));
        this.mEncoderFrameSubmitter.submitFrameToEncoder(frameImageYUV420, endOfStream);
        Log.d((String)TAG, (String)("frame sent to encoder" + EncoderWrapper.threadId()));
        this.getDataFromEncoder(endOfStream);
        Log.d((String)TAG, (String)("frame encoded" + EncoderWrapper.threadId()));
    }

    private void getDataFromEncoder(boolean endOfStream) {
        boolean stopReadingFromEncoder = false;
        block4: while (!stopReadingFromEncoder) {
            this.mBufferInfo = new MediaCodec.BufferInfo();
            int outputBufferId = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            switch (outputBufferId) {
                case -1: {
                    if (endOfStream) {
                        Log.d((String)TAG, (String)"no output available, await end of stream");
                        EncoderWrapper.sleep(15);
                    }
                    stopReadingFromEncoder = true;
                    continue block4;
                }
                case -2: {
                    continue block4;
                }
            }
            if (outputBufferId < 0) {
                Log.w((String)TAG, (String)("unexpected encoder output buffer id: " + outputBufferId));
                continue;
            }
            this.processEncoderOutputBuffer(outputBufferId);
            if (!this.isEndOfStream()) continue;
            stopReadingFromEncoder = true;
        }
    }

    private void processEncoderOutputBuffer(int outputBufferId) {
        if (this.mBufferInfo.size == 0) {
            Log.w((String)TAG, (String)("empty buffer " + outputBufferId));
            this.mEncoder.releaseOutputBuffer(outputBufferId, false);
            return;
        }
        ByteBuffer encodedData = this.mEncoder.getOutputBuffer(outputBufferId);
        if (encodedData == null) {
            throw new RuntimeException("encoder output buffer " + outputBufferId + " is null");
        }
        this.processEncodedData(encodedData);
        this.mEncoder.releaseOutputBuffer(outputBufferId, false);
    }

    private void processEncodedData(ByteBuffer encodedData) {
        this.adjustEncodedDataPosition(encodedData);
        this.adjustEncodedDataPosition(encodedData);
        if (this.isCodecPrivateData()) {
            this.notifyCodecPrivateDataAvailable(encodedData);
            return;
        }
        if (this.isEndOfStream()) {
            Log.d((String)TAG, (String)"end of stream reached");
            return;
        }
        this.sendEncodedFrameToProducerSDK(encodedData);
    }

    private void adjustEncodedDataPosition(ByteBuffer encodedData) {
        encodedData.position(this.mBufferInfo.offset);
        encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
    }

    private boolean isEndOfStream() {
        return (this.mBufferInfo.flags & 4) != 0;
    }

    private boolean isCodecPrivateData() {
        return (this.mBufferInfo.flags & 2) != 0;
    }

    private void notifyCodecPrivateDataAvailable(ByteBuffer codecPrivateDataBuffer) {
        Log.d((String)TAG, (String)"got codec private data");
        ByteBuffer privateData = codecPrivateDataBuffer;
        byte[] codecPrivateDataArray = this.convertToArray(privateData);
        this.mCodecPrivateDataListener.onCodecPrivateDataAvailable(codecPrivateDataArray);
    }

    private void sendEncodedFrameToProducerSDK(ByteBuffer encodedData) {
        long currentTime = System.currentTimeMillis();
        Log.d((String)TAG, (String)("time between frames: " + (currentTime - this.mLastRecordedFrameTimestamp) + "ms"));
        this.mLastRecordedFrameTimestamp = currentTime;
        if (this.mFragmentStart == 0L) {
            this.mFragmentStart = currentTime;
        }
        ByteBuffer frameData = encodedData;
        this.mFrameAvailableListener.onFrameAvailable(FrameUtility.createFrame(this.mBufferInfo, 1L + currentTime - this.mFragmentStart, this.mFrameIndex++, frameData));
    }

    public void stop() {
        Log.d((String)TAG, (String)"stopping encoder");
        this.mIsStopped = true;
        this.mEncoder.stop();
        this.mEncoder.release();
    }

    private byte[] convertToArray(ByteBuffer byteBuffer) {
        byte[] array = new byte[byteBuffer.remaining()];
        byteBuffer.get(array);
        return array;
    }

    private static String threadId() {
        return " | threadId=" + Thread.currentThread().getId();
    }

    private static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static interface CodecPrivateDataAvailableListener {
        public void onCodecPrivateDataAvailable(byte[] var1);
    }

    public static interface FrameAvailableListener {
        public void onFrameAvailable(KinesisVideoFrame var1);
    }
}

