/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.client;

import android.content.Context;
import android.support.annotation.NonNull;
import com.amazonaws.kinesisvideo.client.KinesisVideoClientConfiguration;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.internal.client.NativeKinesisVideoClient;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSource;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceConfiguration;
import com.amazonaws.kinesisvideo.internal.producer.client.KinesisVideoServiceClient;
import com.amazonaws.mobileconnectors.kinesisvideo.mediasource.android.AndroidMediaSourceFactory;
import com.amazonaws.mobileconnectors.kinesisvideo.util.CameraUtils;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public final class AndroidKinesisVideoClient
extends NativeKinesisVideoClient {
    private final Context mContext;

    public AndroidKinesisVideoClient(@NonNull Log log, @NonNull Context context, @NonNull KinesisVideoClientConfiguration configuration, @NonNull KinesisVideoServiceClient serviceClient, @NonNull ScheduledExecutorService executor) {
        super(log, configuration, serviceClient, executor);
        this.mContext = context;
    }

    @Override
    public MediaSource createMediaSource(String streamName, MediaSourceConfiguration mediaSourceConfiguration) throws KinesisVideoException {
        MediaSource mediaSource = AndroidMediaSourceFactory.createMediaSource(streamName, this.mContext, mediaSourceConfiguration);
        this.registerMediaSource(mediaSource);
        return mediaSource;
    }

    @Override
    public List<MediaSourceConfiguration.Builder<? extends MediaSourceConfiguration>> listSupportedConfigurations() {
        return CameraUtils.getSupportedCameraConfigrations(this.mContext);
    }
}

