/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.camera;

import android.app.Activity;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.mobileconnectors.kinesisvideo.mediasource.android.AndroidCameraMediaSource;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class CameraAdapter {
    private static final String TAG = "CameraAdapter";
    private CameraDevice mCameraDevice;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private HandlerThread mBackgroundThread;
    private final Context mContext;
    private String mCameraId;
    private Handler mBackgroundHandler;
    private CameraCaptureSession mActivePreviewSession;

    public CameraAdapter(Context context, String cameraId) {
        this.mContext = context;
        this.mCameraId = cameraId;
    }

    public void openCamera(AndroidCameraMediaSource.OpenCameraCallback cameraOpenCameraCallback) {
        this.startBackgroundThread();
        if (null == this.mContext || this.isActivityFinishing(this.mContext)) {
            Log.i((String)TAG, (String)("trying to open camera when activity is stopped" + this.threadId()));
            return;
        }
        Log.i((String)TAG, (String)("trying to open camera" + this.threadId()));
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        try {
            this.tryAcquireLock();
            manager.openCamera(this.mCameraId, this.adaptCameraStateCallback(cameraOpenCameraCallback), new Handler(Looper.getMainLooper()));
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("failed to open camera" + this.threadId()), (Throwable)e);
            cameraOpenCameraCallback.onError(new KinesisVideoException(e));
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)("failed to open camera" + this.threadId()), (Throwable)e);
            cameraOpenCameraCallback.onError(new KinesisVideoException(e));
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)("failed to open camera" + this.threadId()), (Throwable)e);
            cameraOpenCameraCallback.onError(new KinesisVideoException(e));
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("Permission issue " + this.threadId()), (Throwable)e);
            cameraOpenCameraCallback.onError(new KinesisVideoException(e));
        }
    }

    private boolean isActivityFinishing(Context context) {
        return Activity.class.isAssignableFrom(context.getClass()) && ((Activity)context).isFinishing();
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void tryAcquireLock() throws InterruptedException {
        Log.d((String)TAG, (String)("try acquire" + this.threadId()));
        if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("Time out waiting to lock camera opening." + this.threadId());
        }
    }

    private CameraDevice.StateCallback adaptCameraStateCallback(final AndroidCameraMediaSource.OpenCameraCallback cameraOpenCameraCallback) {
        return new CameraDevice.StateCallback(){

            public void onOpened(CameraDevice cameraDevice) {
                Log.i((String)CameraAdapter.TAG, (String)("opened" + CameraAdapter.this.threadId()));
                CameraAdapter.this.mCameraDevice = cameraDevice;
                CameraAdapter.this.mCameraOpenCloseLock.release();
                cameraOpenCameraCallback.onOpened();
            }

            public void onDisconnected(CameraDevice cameraDevice) {
                Log.i((String)CameraAdapter.TAG, (String)("disconnected" + CameraAdapter.this.threadId()));
                CameraAdapter.this.mCameraOpenCloseLock.release();
                cameraDevice.close();
                CameraAdapter.this.mCameraDevice = null;
            }

            public void onError(CameraDevice cameraDevice, int error) {
                Log.i((String)CameraAdapter.TAG, (String)("error" + CameraAdapter.this.threadId()));
                CameraAdapter.this.mCameraOpenCloseLock.release();
                cameraDevice.close();
                CameraAdapter.this.mCameraDevice = null;
                cameraOpenCameraCallback.onError(new KinesisVideoException("blah"));
            }
        };
    }

    public void closeCamera() {
        this.stopActiveSession();
        this.releaseCamera();
        this.stopBackgroundThread();
    }

    private void stopActiveSession() {
        try {
            Log.d((String)TAG, (String)"stopping active capture session");
            this.mActivePreviewSession.stopRepeating();
            this.mActivePreviewSession.close();
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"unable to stop repeating capture session", (Throwable)e);
        }
    }

    private void releaseCamera() {
        Log.d((String)TAG, (String)"releasing camera");
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing." + this.threadId());
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void stopBackgroundThread() {
        Log.d((String)TAG, (String)"stopping background thread");
        this.mBackgroundThread.quit();
        this.mBackgroundThread = null;
        this.mBackgroundHandler = null;
        Log.d((String)TAG, (String)"stopped background thread");
    }

    public void startPreview(List<Surface> previewSurfaces, AndroidCameraMediaSource.CaptureCallback captureCallback) {
        try {
            this.closeActivePreviewSession();
            this.mCameraDevice.createCaptureSession(previewSurfaces, this.adaptCaptureSessionCallback(previewSurfaces, captureCallback), this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void closeActivePreviewSession() {
        if (this.mActivePreviewSession != null) {
            this.mActivePreviewSession.close();
            this.mActivePreviewSession = null;
        }
    }

    private CameraCaptureSession.StateCallback adaptCaptureSessionCallback(final List<Surface> previewSurfaces, final AndroidCameraMediaSource.CaptureCallback captureCallback) {
        return new CameraCaptureSession.StateCallback(){

            public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                Log.i((String)CameraAdapter.TAG, (String)("created capture session" + CameraAdapter.this.threadId()));
                CameraAdapter.this.mActivePreviewSession = cameraCaptureSession;
                CameraAdapter.this.captureContinously(previewSurfaces);
                captureCallback.onStarted();
            }

            public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                Log.i((String)CameraAdapter.TAG, (String)("failed to create capture session" + CameraAdapter.this.threadId()));
                captureCallback.onFailed();
            }
        };
    }

    private void captureContinously(List<Surface> previewSurfaces) {
        try {
            CaptureRequest.Builder previewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            for (Surface surface : previewSurfaces) {
                previewRequestBuilder.addTarget(surface);
            }
            previewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            this.mActivePreviewSession.setRepeatingRequest(previewRequestBuilder.build(), null, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private String threadId() {
        return " | threadId=" + Thread.currentThread().getId();
    }
}

