/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.stream.throttling;

import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.stream.throttling.BandwidthThrottler;
import java.util.Random;

public class BandwidthThrottlerImpl
implements BandwidthThrottler {
    private static final long BITS_IN_A_KILOBIT = 1024L;
    private static final long BITS_IN_A_BYTE = 8L;
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static final double ACTUAL_PAYLOAD_PERCENTAGE = 1.0;
    private static final int MAX_RANDOM_VALUE = 1;
    private static final int DEFAULT_RESET_SUBINTERVAL = 20;
    private final Random randomGenerator = new Random();
    private final ThrottlingParams upstream = new ThrottlingParams();
    private long absoluteMaxBps;

    public BandwidthThrottlerImpl(long maxBps) {
        this.setAbsoluteMaxBps(maxBps);
        this.setUpstreamKbps(maxBps / 1024L);
    }

    private static void sleep(long sleepDuration) {
        try {
            Thread.sleep(sleepDuration);
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
    }

    public void setAbsoluteMaxBps(long maxBps) {
        this.absoluteMaxBps = maxBps;
        this.setMaxBps(this.upstream, this.upstream.maxBps);
    }

    @Override
    public void setUpstreamKbps(long kbps) {
        Preconditions.checkArgument(kbps > 0L, String.format("Given bandwidth value %d is not positive.", kbps));
        long bps = kbps * 1024L / 8L;
        this.setMaxBps(this.upstream, bps);
    }

    @Override
    public int getAllowedBytes(int len) {
        int allowed;
        while ((allowed = this.getAllowedBytesWrite(len)) <= 0) {
            long sleepDuration = this.timeToNextReset(this.upstream);
            if (sleepDuration <= 0L) continue;
            BandwidthThrottlerImpl.sleep(sleepDuration += (long)this.randomGenerator.nextInt(1));
        }
        return allowed;
    }

    private void setMaxBps(ThrottlingParams params, long maxBps) {
        params.maxBps = Math.min(this.absoluteMaxBps, maxBps);
        params.adjustedMaxBps = (long)((double)params.maxBps * 1.0);
        params.nextResetSubIntervals = 20L;
        params.reset();
    }

    private long timeToNextReset(ThrottlingParams params) {
        return params.timeToNextReset();
    }

    private int getAllowedBytesWrite(int len) {
        return this.getAllowedBytesInternal(this.upstream, len);
    }

    private int getAllowedBytesInternal(ThrottlingParams params, int len) {
        this.resetCounterIfNecessary(params);
        int allowed = (long)len > params.remainingBps ? (int)params.remainingBps : len;
        params.remainingBps = params.remainingBps - (long)allowed;
        return allowed;
    }

    private void resetCounterIfNecessary(ThrottlingParams params) {
        if (params.timeToNextReset() < 0L) {
            params.reset();
        }
    }

    private static class ThrottlingParams {
        private long maxBps;
        private long remainingBps;
        private long adjustedMaxBps;
        private long nextResetTimestamp;
        private long nextResetSubIntervals;

        private ThrottlingParams() {
        }

        private long timeToNextReset() {
            return this.nextResetTimestamp - System.currentTimeMillis();
        }

        private void reset() {
            this.remainingBps = this.adjustedMaxBps / this.nextResetSubIntervals;
            this.nextResetTimestamp = System.currentTimeMillis() + 1000L / this.nextResetSubIntervals;
        }
    }
}

