/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.producer;

import android.support.annotation.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;

public class KinesisVideoFrame {
    private final int mIndex;
    private final int mFlags;
    private final long mDecodingTs;
    private final long mPresentationTs;
    private final long mDuration;
    private final ByteBuffer mData;

    public KinesisVideoFrame(int index, int flags, long decodingTs, long presentationTs, long duration, @NonNull ByteBuffer data) {
        this.mIndex = index;
        this.mFlags = flags;
        this.mDecodingTs = decodingTs;
        this.mPresentationTs = presentationTs;
        this.mDuration = duration;
        this.mData = Objects.requireNonNull(data);
        this.removeTrailingZeros();
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public long getDecodingTs() {
        return this.mDecodingTs;
    }

    public long getPresentationTs() {
        return this.mPresentationTs;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public int getSize() {
        return this.mData.remaining();
    }

    @NonNull
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = this.mData;
        try {
            if (this.mData.hasArray()) {
                byteBuffer = ByteBuffer.allocateDirect(this.mData.remaining());
                byteBuffer.put(this.mData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteBuffer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "mIndex=" + this.mIndex + ", mFlags=" + this.mFlags + ", mDecodingTs=" + this.mDecodingTs + ", mPresentationTs=" + this.mPresentationTs + ", mDuration=" + this.mDuration + ", mData=" + this.mData + "}";
    }

    private void removeTrailingZeros() {
        for (int index = this.mData.limit() - 1; index > this.mData.position(); --index) {
            if (this.mData.get(index) == 0) continue;
            this.mData.limit(index + 1);
            break;
        }
    }
}

