/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.service;

import android.support.annotation.NonNull;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.function.Consumer;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.encoding.ChunkDecoder;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducerStream;
import com.amazonaws.kinesisvideo.internal.service.exception.AccessDeniedException;
import com.amazonaws.kinesisvideo.internal.service.exception.AmazonServiceException;
import com.amazonaws.kinesisvideo.internal.service.exception.ResourceNotFoundException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class BlockingAckConsumer
implements Consumer<InputStream> {
    private static final long RESPONSE_TIMEOUT_IN_MILLISECONDS = 10000L;
    private static final int HTTP_OK = 200;
    private static final int HTTP_BAD_REQUEST = 400;
    private static final int HTTP_NOT_FOUND = 404;
    private static final int HTTP_ACCESS_DENIED = 403;
    private final Consumer<InputStream> inputStreamConsumer;
    private final CountDownLatch responseLatch;
    private Exception storedException;
    private Log log;
    private KinesisVideoProducerStream kinesisVideoProducerStream;

    public BlockingAckConsumer(@NonNull Consumer<InputStream> inputStreamConsumer, Log log, @NonNull KinesisVideoProducerStream kinesisVideoProducerStream) {
        this.inputStreamConsumer = Preconditions.checkNotNull(inputStreamConsumer);
        this.responseLatch = new CountDownLatch(1);
        this.log = log;
        this.kinesisVideoProducerStream = kinesisVideoProducerStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void accept(@NonNull InputStream inputStream) {
        Preconditions.checkNotNull(inputStream);
        try {
            responseStatus = ChunkDecoder.readStatusLine(inputStream);
            responseCode = responseStatus.getStatusCode();
            switch (responseCode) {
                case 200: {
                    this.log.debug(String.format("PutMedia call for stream %s return OK with request id %s", new Object[]{this.kinesisVideoProducerStream.getStreamName(), ChunkDecoder.decodeHeaders(inputStream)}));
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 400: {
                    throw new AmazonServiceException("PutMedia call returned bad request: " + responseStatus.getReason());
                }
                case 404: {
                    throw new ResourceNotFoundException("Resource not found: " + responseStatus.getReason());
                }
                case 403: {
                    throw new AccessDeniedException("Access is denied: " + responseStatus.getReason());
                }
                default: {
                    throw new AmazonServiceException("PutMedia call returned status code " + responseCode + " with reason: " + responseStatus.getReason());
                }
            }
        }
        catch (Exception e) {
            this.storedException = e;
        }
        finally {
            this.responseLatch.countDown();
        }
        if (this.storedException == null) {
            this.inputStreamConsumer.accept(inputStream);
        }
    }

    public void awaitResponse() throws KinesisVideoException {
        try {
            if (!this.responseLatch.await(10000L, TimeUnit.MILLISECONDS)) {
                throw new KinesisVideoException("Getting PutMedia Response timed out");
            }
        }
        catch (InterruptedException e) {
            throw new KinesisVideoException(e);
        }
        finally {
            if (this.storedException != null) {
                if (this.storedException instanceof KinesisVideoException) {
                    throw (KinesisVideoException)this.storedException;
                }
                throw new KinesisVideoException(this.storedException);
            }
        }
    }
}

