/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.producer.jni;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoMetrics;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducerStream;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoStreamMetrics;
import com.amazonaws.kinesisvideo.internal.producer.ReadResult;
import com.amazonaws.kinesisvideo.internal.producer.jni.NativeKinesisVideoProducerJni;
import com.amazonaws.kinesisvideo.producer.FrameFlags;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFragmentAck;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;
import com.amazonaws.kinesisvideo.producer.ProducerException;
import com.amazonaws.kinesisvideo.producer.StreamCallbacks;
import com.amazonaws.kinesisvideo.producer.StreamInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class NativeKinesisVideoProducerStream
implements KinesisVideoProducerStream {
    private static final int SERVICE_CALL_RESULT_OK = 200;
    private final NativeKinesisVideoProducerJni mKinesisVideoProducerJni;
    private final long mStreamHandle;
    private final StreamInfo mStreamInfo;
    private final StreamCallbacks mStreamCallbacks;
    private final CountDownLatch mReadyLatch;
    private final CountDownLatch mStoppedLatch;
    private final Log mLog;
    private final KinesisVideoStreamMetrics mStreamMetrics;
    private final Map<Long, NativeDataInputStream> mInputStreamMap;

    public NativeKinesisVideoProducerStream(@NonNull NativeKinesisVideoProducerJni kinesisVideoProducerJni, @NonNull StreamInfo streamInfo, long streamHandle, @NonNull Log log, @Nullable StreamCallbacks streamCallbacks) {
        this.mKinesisVideoProducerJni = Preconditions.checkNotNull(kinesisVideoProducerJni);
        this.mStreamInfo = Preconditions.checkNotNull(streamInfo);
        Preconditions.checkState(streamHandle != 0L);
        this.mStreamHandle = streamHandle;
        this.mStreamCallbacks = streamCallbacks;
        this.mReadyLatch = new CountDownLatch(1);
        this.mStoppedLatch = new CountDownLatch(1);
        this.mLog = Preconditions.checkNotNull(log);
        this.mStreamMetrics = new KinesisVideoStreamMetrics();
        this.mInputStreamMap = new HashMap<Long, NativeDataInputStream>();
    }

    @Override
    public InputStream getDataStream(long uploadHandle) throws ProducerException {
        NativeDataInputStream inputStream = new NativeDataInputStream(uploadHandle);
        this.mInputStreamMap.put(uploadHandle, inputStream);
        return inputStream;
    }

    @Override
    public void getStreamData(@NonNull byte[] fillBuffer, int offset, int length, @NonNull ReadResult readResult) throws ProducerException {
        this.mKinesisVideoProducerJni.getStreamData(this.mStreamHandle, fillBuffer, offset, length, readResult);
    }

    @Override
    public void putFrame(@NonNull KinesisVideoFrame kinesisVideoFrame) throws ProducerException {
        Preconditions.checkNotNull(kinesisVideoFrame);
        this.mLog.debug("PutFrame index: %s, pts: %s, dts: %s, duration: %s, keyFrame: %s, flags: %s", kinesisVideoFrame.getIndex(), kinesisVideoFrame.getPresentationTs(), kinesisVideoFrame.getDecodingTs(), kinesisVideoFrame.getDuration(), FrameFlags.isKeyFrame(kinesisVideoFrame.getFlags()), kinesisVideoFrame.getFlags());
        if (FrameFlags.isKeyFrame(kinesisVideoFrame.getFlags())) {
            KinesisVideoMetrics kinesisVideoMetrics = this.mKinesisVideoProducerJni.getMetrics();
            KinesisVideoStreamMetrics streamMetrics = this.getMetrics();
            this.mLog.debug("Kinesis Video client and stream metrics\n\t>> Overall storage size: %s\n\t>> Available storage size: %s\n\t>> Allocated storage size: %s\n\t>> Total view allocation size: %s\n\t>> Total streams frame rate: %s\n\t>> Total streams transfer rate: %s\n\t>> Current view duration: %s\n\t>> Overall view duration: %s\n\t>> Current view size: %s\n\t>> Overall view size: %s\n\t>> Current frame rate: %s\n\t>> Current transfer rate: %s", kinesisVideoMetrics.getContentStoreSize(), kinesisVideoMetrics.getContentStoreAvailableSize(), kinesisVideoMetrics.getContentStoreAllocatedSize(), kinesisVideoMetrics.getTotalContentViewSize(), kinesisVideoMetrics.getTotalFrameRate(), kinesisVideoMetrics.getTotalTransferRate(), streamMetrics.getCurrentViewDurationInTimeUnits(), streamMetrics.getOverallViewDurationInTimeUnits(), streamMetrics.getCurrentViewSize(), streamMetrics.getOverallViewSize(), streamMetrics.getCurrentFrameRate(), streamMetrics.getCurrentTransferRate());
        }
        this.mKinesisVideoProducerJni.putFrame(this.mStreamHandle, kinesisVideoFrame);
    }

    @Override
    public void putFragmentMetadata(@NonNull String metadataName, @NonNull String metadataValue, boolean persistent) throws ProducerException {
        Preconditions.checkNotNull(metadataName);
        Preconditions.checkNotNull(metadataValue);
        this.mKinesisVideoProducerJni.putFragmentMetadata(this.mStreamHandle, metadataName, metadataValue, persistent);
    }

    @Override
    public void fragmentAck(long uploadHandle, @NonNull KinesisVideoFragmentAck kinesisVideoFragmentAck) throws ProducerException {
        Preconditions.checkNotNull(kinesisVideoFragmentAck);
        this.mKinesisVideoProducerJni.fragmentAck(this.mStreamHandle, uploadHandle, kinesisVideoFragmentAck);
    }

    @Override
    public void parseFragmentAck(long uploadHandle, @NonNull String kinesisVideoFragmentAck) throws ProducerException {
        Preconditions.checkNotNull(kinesisVideoFragmentAck);
        this.mKinesisVideoProducerJni.parseFragmentAck(this.mStreamHandle, uploadHandle, kinesisVideoFragmentAck);
    }

    @Override
    public void streamFormatChanged(@Nullable byte[] codecPrivateData) throws ProducerException {
        this.mKinesisVideoProducerJni.streamFormatChanged(this.mStreamHandle, codecPrivateData);
    }

    @Override
    public void streamTerminated(long uploadHandle, int statusCode) throws ProducerException {
        this.mKinesisVideoProducerJni.streamTerminated(this.mStreamHandle, uploadHandle, statusCode);
    }

    @Override
    public void stopStream() throws ProducerException {
        this.mKinesisVideoProducerJni.stopStream(this.mStreamHandle);
    }

    @Override
    public void stopStreamSync() throws ProducerException {
        this.stopStream();
        try {
            this.awaitStopped();
        }
        catch (ProducerException e) {
            this.mLog.exception(e, "Stopping stream threw an exception. Force stopping the input stream.", new Object[0]);
        }
    }

    @Override
    @NonNull
    public KinesisVideoStreamMetrics getMetrics() throws ProducerException {
        this.mKinesisVideoProducerJni.getStreamMetrics(this.mStreamHandle, this.mStreamMetrics);
        return this.mStreamMetrics;
    }

    @Override
    public String getStreamName() {
        return this.mStreamInfo.getName();
    }

    @Override
    public long getStreamHandle() {
        return this.mStreamHandle;
    }

    @Override
    public void streamUnderflowReport() throws ProducerException {
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.streamUnderflowReport();
        }
    }

    @Override
    public void streamLatencyPressure(long duration) throws ProducerException {
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.streamLatencyPressure(duration);
        }
    }

    @Override
    public void streamConnectionStale(long lastAckDuration) throws ProducerException {
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.streamConnectionStale(lastAckDuration);
        }
    }

    @Override
    public void fragmentAckReceived(@NonNull KinesisVideoFragmentAck fragmentAck) throws ProducerException {
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.fragmentAckReceived(fragmentAck);
        }
    }

    @Override
    public void droppedFrameReport(long frameTimecode) throws ProducerException {
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.droppedFrameReport(frameTimecode);
        }
    }

    @Override
    public void droppedFragmentReport(long fragmentTimecode) throws ProducerException {
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.droppedFragmentReport(fragmentTimecode);
        }
    }

    @Override
    public void streamErrorReport(long fragmentTimecode, long statusCode) throws ProducerException {
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.streamErrorReport(fragmentTimecode, statusCode);
        }
    }

    @Override
    public void streamDataAvailable(long uploadHandle, long duration, long availableSize) throws ProducerException {
        NativeDataInputStream inputStreamToNotify = this.mInputStreamMap.get(uploadHandle);
        if (inputStreamToNotify != null) {
            inputStreamToNotify.notifyReaderThread(duration, availableSize);
        } else {
            this.mLog.warn("Data available notification for non-existing uploadHandle %d", uploadHandle);
        }
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.streamDataAvailable(uploadHandle, duration, availableSize);
        }
    }

    @Override
    public void streamReady() throws ProducerException {
        this.mLog.debug("Stream %s is ready", this.mStreamInfo.getName());
        this.mReadyLatch.countDown();
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.streamReady();
        }
    }

    @Override
    public void streamClosed(long uploadHandle) throws ProducerException {
        this.mLog.debug("Stream %s is closed", this.mStreamInfo.getName());
        this.mStoppedLatch.countDown();
        if (this.mStreamCallbacks != null) {
            this.mStreamCallbacks.streamClosed(uploadHandle);
        }
    }

    @Override
    public void resetConnection() throws ProducerException {
        this.mLog.debug("Current connection of stream %s is being reset", this.mStreamInfo.getName());
        this.streamTerminated(-1L, 200);
    }

    public void awaitReady() throws ProducerException {
        try {
            if (!this.mReadyLatch.await(15000L, TimeUnit.MILLISECONDS)) {
                throw new ProducerException("KinesisVideo producer stream creation time out", 15);
            }
        }
        catch (InterruptedException e) {
            throw new ProducerException(e);
        }
    }

    public void awaitStopped() throws ProducerException {
        try {
            if (!this.mStoppedLatch.await(15000L, TimeUnit.MILLISECONDS)) {
                throw new ProducerException("KinesisVideo producer stream stopping time out", 15);
            }
        }
        catch (InterruptedException e) {
            throw new ProducerException(e);
        }
    }

    private void notifyEndOfStream(long uploadHandle) {
        NativeDataInputStream inputStream = this.mInputStreamMap.get(uploadHandle);
        if (inputStream != null) {
            inputStream.endOfReaderThread();
        } else {
            this.mLog.error("NativeDataInputStream corresponding to upload handle %d is not found.", uploadHandle);
        }
    }

    private class NativeDataInputStream
    extends InputStream {
        private volatile boolean mStreamClosed = false;
        private final Object mMonitor = new Object();
        private boolean mDataAvailable = false;
        private long mAvailableDataSize = 0L;
        private final ReadResult mReadResult;
        final long mUploadHandle;

        public NativeDataInputStream(long uploadHandle) {
            this.mUploadHandle = uploadHandle;
            this.mReadResult = new ReadResult();
        }

        @Override
        public int read() throws IOException {
            throw new IOException("Can't call byte-by-byte");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.mStreamClosed) {
                NativeKinesisVideoProducerStream.this.mLog.warn("Stream %s with uploadHandle %d has been closed", NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle);
            }
            int bytesRead = -1;
            while (!this.mStreamClosed) {
                Object object = this.mMonitor;
                synchronized (object) {
                    while (!this.mDataAvailable) {
                        try {
                            NativeKinesisVideoProducerStream.this.mLog.debug("no data for stream %s with uploadHandle %d, waiting", NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle);
                            this.mMonitor.wait();
                        }
                        catch (InterruptedException e) {
                            NativeKinesisVideoProducerStream.this.mLog.exception(e, "Waiting for the data availability with uploadHandle %dthrew an interrupted exception. Continuing...", this.mUploadHandle);
                        }
                    }
                    this.mDataAvailable = false;
                    if (this.mStreamClosed) {
                        bytesRead = -1;
                        NativeKinesisVideoProducerStream.this.mLog.debug("Being notified to close stream %s with uploadHandle %d", NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle);
                        return bytesRead;
                    }
                }
                try {
                    NativeKinesisVideoProducerStream.this.mKinesisVideoProducerJni.getStreamData(NativeKinesisVideoProducerStream.this.mStreamHandle, b, off, len, this.mReadResult);
                    bytesRead = this.mReadResult.getReadBytes();
                    NativeKinesisVideoProducerStream.this.mLog.debug("getStreamData fill %d bytes for stream %s with uploadHandle %d", bytesRead, NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle);
                    if (this.mReadResult.isEndOfStream()) {
                        if (this.mReadResult.getUploadHandle() == this.mUploadHandle) {
                            NativeKinesisVideoProducerStream.this.mLog.info("Received end-of-stream indicator for %s, uploadHandle %d", NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle);
                            this.mStreamClosed = true;
                            if (0 == bytesRead) {
                                bytesRead = -1;
                            }
                        } else {
                            NativeKinesisVideoProducerStream.this.mLog.debug("Found end of stream for stream %s on uploadHandle %d for previous uploadHandle %d", NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle, this.mReadResult.getUploadHandle());
                            NativeKinesisVideoProducerStream.this.notifyEndOfStream(this.mReadResult.getUploadHandle());
                        }
                    }
                    object = this.mMonitor;
                    synchronized (object) {
                        if (bytesRead != 0) {
                            if (bytesRead != -1 && this.mAvailableDataSize - (long)bytesRead > 0L) {
                                this.mDataAvailable = true;
                            }
                            break;
                        }
                    }
                }
                catch (ProducerException e) {
                    NativeKinesisVideoProducerStream.this.mLog.exception(e, "Reader threw an exception", new Object[0]);
                    throw new IOException(e);
                }
            }
            NativeKinesisVideoProducerStream.this.mLog.debug("Streamed %d bytes for stream %s with uploadHandle %d", bytesRead, NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle);
            if (-1 == bytesRead) {
                NativeKinesisVideoProducerStream.this.mLog.debug("Closing stream %s with uploadHandle %d", NativeKinesisVideoProducerStream.this.mStreamInfo.getName(), this.mUploadHandle);
            }
            return bytesRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public void close() throws IOException {
            this.mStreamClosed = true;
            this.notifyReaderThread(0L, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyReaderThread(long duration, long availableSize) {
            Object object = this.mMonitor;
            synchronized (object) {
                this.mAvailableDataSize = availableSize;
                NativeKinesisVideoProducerStream.this.mLog.debug("Data availability notification. Upload handle: %d, Size: %d, Duration %d ", this.mUploadHandle, availableSize, duration);
                this.mDataAvailable = true;
                this.mMonitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void endOfReaderThread() {
            Object object = this.mMonitor;
            synchronized (object) {
                this.mDataAvailable = true;
                this.mStreamClosed = true;
                this.mMonitor.notify();
            }
        }
    }
}

