/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.mediasource.bytes;

import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.internal.mediasource.OnStreamDataAvailable;
import com.amazonaws.kinesisvideo.stream.throttling.DiscreteTimePeriodsThrottler;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BytesGenerator {
    private static final int DISCRETENESS_10HZ = 10;
    private static final int MAX_FRAME_SIZE_BYTES_1024 = 1024;
    private OnStreamDataAvailable streamDataAvailable;
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private final DiscreteTimePeriodsThrottler throttler;
    private final byte[][] framesData = new byte[][]{new byte[1024], new byte[1024], new byte[1024], new byte[1024], new byte[1024], new byte[1024]};
    private final Log log = LogFactory.getLog(BytesGenerator.class);
    private volatile boolean isRunning;
    private int frameCounter = 0;

    public BytesGenerator(int fps) {
        this.throttler = new DiscreteTimePeriodsThrottler(fps, 10);
    }

    public void onStreamDataAvailable(OnStreamDataAvailable streamDataAvailable) {
        this.streamDataAvailable = streamDataAvailable;
    }

    public synchronized void start() {
        if (this.isRunning) {
            throw new IllegalStateException("should stop previous generator before starting the new one");
        }
        this.isRunning = true;
        this.startGeneratorInBackground();
    }

    public synchronized void stop() {
        this.isRunning = false;
    }

    private void startGeneratorInBackground() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BytesGenerator.this.generateBytesAndNotifyListener();
                }
                catch (KinesisVideoException e) {
                    BytesGenerator.this.log.error((Object)"Failed to keep generating frames with Exception", (Throwable)e);
                }
            }
        });
    }

    private void generateBytesAndNotifyListener() throws KinesisVideoException {
        while (this.isRunning) {
            this.fillArrayWithDigitsOfFramesCounter();
            if (this.streamDataAvailable != null) {
                this.streamDataAvailable.onFrameDataAvailable(ByteBuffer.wrap(this.framesData[this.frameCounter % this.framesData.length]));
            }
            ++this.frameCounter;
            this.throttler.throttle();
        }
    }

    private void fillArrayWithDigitsOfFramesCounter() {
        String counterString = String.valueOf(this.frameCounter) + "|";
        byte[] counterBytes = counterString.getBytes(StandardCharsets.US_ASCII);
        byte[] frameData = this.framesData[this.frameCounter % this.framesData.length];
        for (int i = 0; i < frameData.length; ++i) {
            frameData[i] = counterBytes[i % counterBytes.length];
        }
    }
}

