/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.http;

import android.support.annotation.NonNull;
import com.amazonaws.kinesisvideo.common.function.Consumer;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.http.HttpClient;
import com.amazonaws.kinesisvideo.http.HttpMethodName;
import com.amazonaws.kinesisvideo.socket.SocketFactory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ParallelSimpleHttpClient
implements HttpClient {
    private static final String SPACE = " ";
    private static final String CLRF = "\r\n";
    private static final String HTTP_1_1 = "HTTP/1.1";
    private static final String HEADER_FORMAT = "%s: %s";
    private static final String HOST_HEADER = "Host";
    private final Log log;
    private static final Consumer<OutputStream> NO_OP_SENDER = new Consumer<OutputStream>(){

        @Override
        public void accept(OutputStream outputStream) {
        }
    };
    private static final Consumer<Exception> NO_OP_COMPLETION = new Consumer<Exception>(){

        @Override
        public void accept(Exception object) {
        }
    };
    private final Builder mBuilder;
    private Socket mSocket;
    private InputStream mInputStream;
    private OutputStream mOutputStream;
    private ExecutorService payloadSender;
    private ExecutorService responseReceiver;

    private ParallelSimpleHttpClient(Builder builder) {
        this.mBuilder = builder;
        this.log = this.mBuilder.mLog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void connectAndProcessInBackground() {
        try {
            Preconditions.checkNotNull(this.mBuilder.mReceiver, "No callback set for the receiver!");
            this.initSocket();
            this.startCommunication();
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while connecting to the server ! ", e);
        }
    }

    private void initSocket() throws IOException {
        this.mSocket = new SocketFactory().createSocket(this.mBuilder.mUri);
        if (this.mBuilder.mTimeout != null) {
            this.mSocket.setSoTimeout(this.mBuilder.mTimeout);
        }
        this.mInputStream = this.mSocket.getInputStream();
        this.mOutputStream = this.mSocket.getOutputStream();
    }

    public InputStream connectAndGetResponse() {
        try {
            this.initSocket();
            this.sendInitRequest();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while executing and returning response ! ", e);
        }
        return this.mInputStream;
    }

    private void startCommunication() throws Exception {
        this.sendInitRequest();
        this.sendPayloadInBackground();
        this.receiveResponseInBackground();
    }

    private void sendInitRequest() throws Exception {
        BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter(this.mOutputStream, Charset.defaultCharset()));
        String initRequest = this.getHttpRequestString() + this.getHeadersString() + CLRF;
        this.log.debug("Request: " + initRequest);
        outputWriter.write(initRequest);
        ((Writer)outputWriter).flush();
    }

    private String getHttpRequestString() {
        StringBuilder httpRequest = new StringBuilder();
        return httpRequest.append((Object)this.mBuilder.mMethod).append(SPACE).append(this.mBuilder.mUri.getPath()).append(SPACE).append(HTTP_1_1).append(CLRF).toString();
    }

    @Override
    public HttpMethodName getMethod() {
        return this.mBuilder.mMethod;
    }

    @Override
    public URI getUri() {
        return this.mBuilder.mUri;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.mBuilder.mHeaders;
    }

    @Override
    public InputStream getContent() {
        return null;
    }

    private String getHeadersString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry header : this.mBuilder.mHeaders.entrySet()) {
            String headerString = String.format(HEADER_FORMAT, header.getKey(), header.getValue());
            builder.append(headerString);
            builder.append(CLRF);
        }
        String allHeaders = builder.toString();
        return allHeaders.isEmpty() ? CLRF : allHeaders;
    }

    private void sendPayloadInBackground() {
        if (this.mBuilder.mSender != null) {
            this.payloadSender = Executors.newFixedThreadPool(1);
            this.payloadSender.execute(new Runnable(){

                @Override
                public void run() {
                    Exception storedException = null;
                    try {
                        ParallelSimpleHttpClient.this.log.debug("Start sending data.");
                        ParallelSimpleHttpClient.this.mBuilder.mSender.accept(ParallelSimpleHttpClient.this.mOutputStream);
                        ParallelSimpleHttpClient.this.log.debug("End sending data. Sent all data, close.");
                    }
                    catch (Exception e) {
                        ParallelSimpleHttpClient.this.log.exception(e, "Exception thrown on sending thread", new Object[0]);
                        storedException = e;
                    }
                    finally {
                        if (storedException != null) {
                            ParallelSimpleHttpClient.this.mBuilder.mCompletion.accept(storedException);
                        }
                        ParallelSimpleHttpClient.this.payloadSender.shutdownNow();
                    }
                }
            });
        }
    }

    private void receiveResponseInBackground() {
        if (this.mBuilder.mReceiver != null) {
            this.responseReceiver = Executors.newFixedThreadPool(1);
            this.responseReceiver.execute(new Runnable(){

                @Override
                public void run() {
                    Exception storedException = null;
                    try {
                        ParallelSimpleHttpClient.this.log.debug("Starting receiving data");
                        ParallelSimpleHttpClient.this.mBuilder.mReceiver.accept(ParallelSimpleHttpClient.this.mInputStream);
                        ParallelSimpleHttpClient.this.log.debug("Received all data, close");
                    }
                    catch (Exception e) {
                        ParallelSimpleHttpClient.this.log.exception(e, "Exception thrown on receiving thread", new Object[0]);
                        storedException = e;
                    }
                    finally {
                        ParallelSimpleHttpClient.this.mBuilder.mCompletion.accept(storedException);
                        ParallelSimpleHttpClient.this.responseReceiver.shutdownNow();
                        ParallelSimpleHttpClient.this.closeSocket();
                    }
                }
            });
        }
    }

    public void closeSocket() {
        try {
            this.mSocket.close();
            this.mInputStream.close();
            this.mOutputStream.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Exception while shutting down!", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.payloadSender.shutdownNow();
        this.responseReceiver.shutdownNow();
        this.closeSocket();
        this.mBuilder.mCompletion.accept(null);
    }

    public static final class Builder {
        private final Map<String, String> mHeaders;
        private URI mUri;
        private HttpMethodName mMethod;
        private Consumer<OutputStream> mSender;
        private Consumer<InputStream> mReceiver;
        private Integer mTimeout;
        private Consumer<Exception> mCompletion;
        private Log mLog = new Log(Log.SYSTEM_OUT);

        private Builder() {
            this.mHeaders = new HashMap<String, String>();
            this.mSender = NO_OP_SENDER;
            this.mCompletion = NO_OP_COMPLETION;
        }

        public Builder uri(URI uri) {
            this.mUri = uri;
            this.mHeaders.put(ParallelSimpleHttpClient.HOST_HEADER, uri.getHost());
            return this;
        }

        public Builder method(HttpMethodName method) {
            this.mMethod = method;
            return this;
        }

        public Builder header(String key, String value) {
            this.mHeaders.put(key, value);
            return this;
        }

        public Builder completionCallback(Consumer<Exception> completion) {
            if (completion != null) {
                this.mCompletion = completion;
            }
            return this;
        }

        public Builder setSenderCallback(Consumer<OutputStream> sender) {
            this.mSender = sender;
            return this;
        }

        public Builder setReceiverCallback(Consumer<InputStream> receiver) {
            this.mReceiver = receiver;
            return this;
        }

        public Builder setTimeout(Integer timeout) {
            this.mTimeout = timeout;
            return this;
        }

        public Builder log(@NonNull Log log) {
            this.mLog = log;
            return this;
        }

        public ParallelSimpleHttpClient build() {
            Preconditions.checkNotNull(this.mUri);
            return new ParallelSimpleHttpClient(this);
        }
    }
}

