/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.encoding;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public final class ChunkEncoder {
    public static byte[] encode(byte[] bytes, int count) {
        try {
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            ChunkEncoder.writeChunkSize(writer, count);
            ChunkEncoder.writeCRLF(writer);
            ChunkEncoder.writePayload(writer, bytes, count);
            ChunkEncoder.writeCRLF(writer);
            return writer.toByteArray();
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while encoding chunks ! ", e);
        }
    }

    private static void writeChunkSize(OutputStream socketWrite, int count) throws Exception {
        String hexCount = Integer.toHexString(count);
        socketWrite.write(hexCount.getBytes(StandardCharsets.US_ASCII));
    }

    private static void writeCRLF(OutputStream socketWrite) throws Exception {
        socketWrite.write(13);
        socketWrite.write(10);
    }

    private static void writePayload(OutputStream socketWrite, byte[] payloadBytes, int count) throws Exception {
        socketWrite.write(payloadBytes, 0, count);
    }

    private ChunkEncoder() {
    }
}

