/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.encoding;

import com.amazonaws.kinesisvideo.common.function.Consumer;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.model.Response;
import com.amazonaws.kinesisvideo.model.ResponseStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class ChunkDecoder {
    private static final int HEX_RADIX = 16;
    private static final int MAX_BUFFER_BYTES = 16384;
    private static final int BUFFER_SIZE = 4096;
    private static final String LINE_DELIMITER = "\r\n";
    private static final String PAYLOAD_DELIMITER = "\r\n\r\n";
    private static final Log LOG = new Log(Log.SYSTEM_OUT);

    private ChunkDecoder() {
    }

    public static Map<String, String> decodeHeaders(InputStream inputStream) {
        return ChunkDecoder.parseHeaders(inputStream);
    }

    private static Map<String, String> parseHeaders(InputStream inputStream) {
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            String headersAsString = ChunkDecoder.readInputStream(inputStream, PAYLOAD_DELIMITER.getBytes(StandardCharsets.UTF_8));
            for (String line : headersAsString.split(LINE_DELIMITER)) {
                String[] headerParts = line.split(":", 2);
                if (headerParts.length != 2) continue;
                headers.put(headerParts[0].trim(), headerParts[1].trim());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while decoding headers ! ", e);
        }
        return headers;
    }

    public static ResponseStatus readStatusLine(InputStream inputStream) {
        return ChunkDecoder.parseStatusLine(inputStream);
    }

    private static ResponseStatus parseStatusLine(InputStream inputStream) {
        try {
            String statusLine = ChunkDecoder.readInputStream(inputStream, LINE_DELIMITER.getBytes(StandardCharsets.UTF_8));
            String[] statusLineArray = statusLine.split("\\s");
            return ResponseStatus.builder().protocol(statusLineArray[0]).statusCode(Integer.parseInt(statusLineArray[1])).reason(ChunkDecoder.joinSubArray(statusLineArray, 2)).build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while reading status line ! ", e);
        }
    }

    private static String joinSubArray(String[] array, int startIndex) {
        StringBuilder builder = new StringBuilder();
        for (int i = startIndex; i < array.length; ++i) {
            builder.append(array[i]);
            if (i >= array.length - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    private static String readInputStream(InputStream inputStream, byte[] delimiter) throws IOException {
        byte[] buffer = new byte[4096];
        int result = 0;
        int offset = 0;
        while ((result = inputStream.read(buffer, offset++, 1)) > -1 && ChunkDecoder.arrayIndexOf(buffer, 0, offset, delimiter) == -1) {
        }
        return new String(buffer, 0, offset, StandardCharsets.UTF_8);
    }

    public static int arrayIndexOf(byte[] haystack, int tail, int head, byte[] needle) {
        int index = tail;
        while (index != head) {
            boolean match = false;
            for (int j = 0; j < needle.length; ++j) {
                boolean bl = match = haystack[(index + j) % haystack.length] == needle[j];
                if (!match) break;
            }
            if (match) {
                return index;
            }
            index = index == haystack.length - 1 ? 0 : index + 1;
        }
        return -1;
    }

    public static int parseChunkSize(byte[] buffer, int tail, int head) {
        byte[] tmp;
        if (tail < head) {
            tmp = new byte[head - tail];
            System.arraycopy(buffer, tail, tmp, 0, head - tail);
        } else {
            int len = head + buffer.length - tail;
            tmp = new byte[len];
            System.arraycopy(buffer, tail, tmp, 0, buffer.length - tail);
            System.arraycopy(buffer, 0, tmp, buffer.length - tail, head);
        }
        return Integer.parseInt(new String(tmp, 0, tmp.length, StandardCharsets.UTF_8).trim(), 16);
    }

    public static Response parseStatusLineAndHeaders(InputStream inputStream) {
        return Response.builder().responseStatus(ChunkDecoder.parseStatusLine(inputStream)).responseHeaders(ChunkDecoder.parseHeaders(inputStream)).responsePayload(inputStream).build();
    }

    public static Response parseEntireTextResponse(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));
        return Response.builder().responseStatus(ChunkDecoder.parseStatusLine(inputStream)).responseHeaders(ChunkDecoder.parseHeaders(inputStream)).responseBody(ChunkDecoder.parseTextBody(reader)).responsePayload(inputStream).build();
    }

    private static String parseTextBody(BufferedReader reader) {
        StringBuilder builder = new StringBuilder();
        String line = null;
        do {
            try {
                line = reader.readLine();
                builder.append(line);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (line != null);
        return builder.toString();
    }

    public static Integer decodeAckInResponseBody(InputStream inputStream, Consumer<String> ackTimestampConsumer) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));
        int ackCount = 0;
        try {
            int chunkSize;
            ChunkDecoder.skipResponseHeaders(reader);
            String line = ChunkDecoder.skipEmptyLines(reader);
            LOG.debug("Chunk size: " + line);
            while ((chunkSize = Integer.parseInt(line.trim(), 16)) != 0) {
                int numBytesRead;
                char[] buff = new char[16384];
                int offset = 0;
                do {
                    if ((numBytesRead = reader.read(buff, offset, chunkSize + 2 - offset)) >= 0) continue;
                    throw new RuntimeException("Unexpected end of stream while reading chunked data");
                } while ((offset += numBytesRead) < chunkSize + 2);
                String chunk = new String(buff, 0, chunkSize);
                LOG.debug("Chunk: " + chunk);
                ackTimestampConsumer.accept(chunk);
                line = reader.readLine();
                LOG.debug("Chunk size: " + line);
                if (line != null) continue;
                break;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while decoding Ack in response ! ", e);
        }
        return ackCount;
    }

    private static String skipEmptyLines(BufferedReader reader) throws Throwable {
        String line;
        while ((line = reader.readLine()) != null && line.isEmpty()) {
        }
        return line;
    }

    private static String skipResponseHeaders(BufferedReader reader) throws Throwable {
        String line = ChunkDecoder.skipEmptyLines(reader);
        LOG.debug("Skip header: " + line);
        if (ChunkDecoder.isStatusLine(line)) {
            do {
                line = reader.readLine();
                LOG.debug("Skip header: " + line);
            } while (ChunkDecoder.isNotBlank(line));
        }
        return line;
    }

    private static boolean isNotBlank(CharSequence cs) {
        int strLen;
        int n = strLen = cs == null ? 0 : cs.length();
        if (cs == null || strLen == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isStatusLine(String line) {
        return true;
    }
}

