/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.config;

import java.net.URI;

public final class ClientConfiguration {
    private String region;
    private String serviceName;
    private String apiName;
    private String materialSet;
    private String streamName;
    private URI streamUri;
    private Integer connectionTimeoutInMillis;
    private Integer readTimeoutInMillis;

    public String toString() {
        return "ClientConfiguration [region=" + this.region + ", serviceName=" + this.serviceName + ", apiName=" + this.apiName + ", materialSet=" + this.materialSet + ", streamName=" + this.streamName + ", streamUri=" + this.streamUri + ", connectionTimeoutInMillis=" + this.connectionTimeoutInMillis + ", readTimeoutInMillis=" + this.readTimeoutInMillis + "super=" + super.toString() + "]";
    }

    ClientConfiguration(ClientConfigurationBuilder builder) {
        this.region = builder.region;
        this.serviceName = builder.serviceName;
        this.apiName = builder.apiName;
        this.materialSet = builder.materialSet;
        this.streamName = builder.streamName;
        this.streamUri = builder.streamUri;
        this.connectionTimeoutInMillis = builder.connectionTimeoutInMillis;
        this.readTimeoutInMillis = builder.readTimeoutInMillis;
    }

    public static ClientConfigurationBuilder builder() {
        return new ClientConfigurationBuilder();
    }

    public String getRegion() {
        return this.region;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getMaterialSet() {
        return this.materialSet;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public URI getStreamUri() {
        return this.streamUri;
    }

    public Integer getConnectionTimeoutInMillis() {
        return this.connectionTimeoutInMillis;
    }

    public Integer getReadTimeoutInMillis() {
        return this.readTimeoutInMillis;
    }

    public static class ClientConfigurationBuilder {
        private String region;
        private String serviceName;
        private String apiName;
        private String materialSet;
        private String streamName;
        private URI streamUri;
        private Integer connectionTimeoutInMillis;
        private Integer readTimeoutInMillis;

        ClientConfigurationBuilder() {
        }

        public ClientConfigurationBuilder region(String region) {
            this.region = region;
            return this;
        }

        public ClientConfigurationBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ClientConfigurationBuilder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public ClientConfigurationBuilder materialSet(String materialSet) {
            this.materialSet = materialSet;
            return this;
        }

        public ClientConfigurationBuilder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public ClientConfigurationBuilder streamUri(URI streamUri) {
            this.streamUri = streamUri;
            return this;
        }

        public ClientConfigurationBuilder connectionTimeoutInMillis(Integer connectionTimeoutInMillis) {
            this.connectionTimeoutInMillis = connectionTimeoutInMillis;
            return this;
        }

        public ClientConfigurationBuilder readTimeoutInMillis(Integer readTimeoutInMillis) {
            this.readTimeoutInMillis = readTimeoutInMillis;
            return this;
        }

        public ClientConfiguration build() {
            return new ClientConfiguration(this);
        }
    }
}

