/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.common.logging;

import android.support.annotation.NonNull;
import com.amazonaws.kinesisvideo.common.logging.LogLevel;
import com.amazonaws.kinesisvideo.common.logging.OutputChannel;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    private static final String BASE_TAG = "KinesisVideoStreams";
    private static final String TAG_DELIMITER = ".";
    private static final String MESSAGE_DELIMITER = ": ";
    private static final int DEFAULT_MESSAGE_BUFFER = 1024;
    public static final OutputChannel SYSTEM_OUT = new OutputChannel(){

        @Override
        public void print(int level, String tag, String message) {
            System.out.println(String.format("%s%s%s\t%s", LogLevel.fromInt(level).toString(), Log.MESSAGE_DELIMITER, tag, message));
        }

        public String toString() {
            return "standard output console";
        }
    };
    private final OutputChannel mOutputChannel;
    private final StringBuilder mStringBuilder;
    private String mTag;
    private LogLevel mCurrentLogLevel;

    public Log(@NonNull OutputChannel outputChannel) {
        this(outputChannel, LogLevel.INFO, BASE_TAG);
    }

    public Log(@NonNull OutputChannel outputChannel, LogLevel currentLogLevel, @NonNull String tag) {
        this.mOutputChannel = Preconditions.checkNotNull(outputChannel);
        this.mTag = Preconditions.checkNotNull(tag);
        this.mCurrentLogLevel = currentLogLevel;
        this.mStringBuilder = new StringBuilder(1024);
    }

    public void setCurrentLogLevel(LogLevel logLevel) {
        this.mCurrentLogLevel = logLevel;
    }

    public void setPackagePrefix() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String[] parts = stack[1].getClassName().split("\\.", 0);
        String packageName = parts[parts.length - 1];
        this.mTag = String.format("%s%s%s", BASE_TAG, TAG_DELIMITER, packageName);
    }

    public void log(LogLevel logLevel, String message) {
        if (logLevel.getLogLevel() >= this.mCurrentLogLevel.getLogLevel()) {
            this.mOutputChannel.print(logLevel.getLogLevel(), this.mTag, message);
        }
    }

    public void log(LogLevel logLevel, String template, Object ... args) {
        this.log(logLevel, String.format(template, args));
    }

    public void verbose(String message) {
        this.log(LogLevel.VERBOSE, message);
    }

    public void verbose(String template, Object ... args) {
        this.log(LogLevel.VERBOSE, template, args);
    }

    public void debug(String message) {
        this.log(LogLevel.DEBUG, message);
    }

    public void debug(String template, Object ... args) {
        this.log(LogLevel.DEBUG, template, args);
    }

    public void info(String message) {
        this.log(LogLevel.INFO, message);
    }

    public void info(String template, Object ... args) {
        this.log(LogLevel.INFO, template, args);
    }

    public void warn(String message) {
        this.log(LogLevel.WARN, message);
    }

    public void warn(String template, Object ... args) {
        this.log(LogLevel.WARN, template, args);
    }

    public void error(String message) {
        this.log(LogLevel.ERROR, message);
    }

    public void error(String template, Object ... args) {
        this.log(LogLevel.ERROR, template, args);
    }

    public void assrt(String message) {
        this.log(LogLevel.ASSERT, message);
    }

    public void assrt(String template, Object ... args) {
        this.log(LogLevel.ASSERT, template, args);
    }

    public void exception(Throwable e) {
        this.log(LogLevel.ERROR, this.createMessage("EXCEPTION: ", e.getClass().getSimpleName(), MESSAGE_DELIMITER, e.getMessage()));
    }

    public void exception(Throwable e, String template, Object ... args) {
        this.log(LogLevel.ERROR, this.createMessage("EXCEPTION: ", e.getClass().getSimpleName(), MESSAGE_DELIMITER, String.format(template, args), MESSAGE_DELIMITER, e.getMessage()));
    }

    private String createMessage(Object ... args) {
        if (args.length == 1 && args[0] instanceof String) {
            return (String)args[0];
        }
        this.mStringBuilder.setLength(0);
        this.mStringBuilder.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z' ").format(new Date()));
        this.mStringBuilder.append("T").append(Thread.currentThread().getId()).append(MESSAGE_DELIMITER);
        this.addFlattenedArray(args);
        return this.mStringBuilder.toString();
    }

    private void addFlattenedArray(Object[] args) {
        for (Object item : args) {
            if (null == item) {
                this.mStringBuilder.append("null");
                continue;
            }
            if (item instanceof byte[]) {
                this.addHexString((byte[])item);
                continue;
            }
            if (item instanceof Object[]) {
                this.addFlattenedArray((Object[])item);
                continue;
            }
            this.mStringBuilder.append(item.toString());
        }
    }

    private void addHexString(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            int unsignedByte = bytes[i] & 0xFF;
            if (unsignedByte < 16) {
                this.mStringBuilder.append('0');
            }
            this.mStringBuilder.append(Integer.toHexString(unsignedByte));
        }
    }
}

