/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.auth;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentials;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentialsProvider;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.producer.AuthCallbacks;
import com.amazonaws.kinesisvideo.producer.AuthInfo;
import com.amazonaws.kinesisvideo.producer.AuthInfoType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DefaultAuthCallbacks
implements AuthCallbacks {
    private static final int CREDENTIALS_UPDATE_TIMEOUT_MILLIS = 10000;
    public static final long CREDENTIALS_NEVER_EXPIRE = Long.MAX_VALUE;
    private final KinesisVideoCredentialsProvider credentialsProvider;
    private final ScheduledExecutorService executor;
    private final Log log;
    private byte[] serializedCredentials;
    private long expiration;

    public DefaultAuthCallbacks(@NonNull KinesisVideoCredentialsProvider credentialsProvider, @NonNull ScheduledExecutorService executor, @NonNull Log log) {
        this.credentialsProvider = Preconditions.checkNotNull(credentialsProvider);
        this.executor = Preconditions.checkNotNull(executor);
        this.log = Preconditions.checkNotNull(log);
    }

    @Override
    @Nullable
    public AuthInfo getDeviceCertificate() {
        throw new RuntimeException("Certificate integration is not implemented");
    }

    @Override
    @Nullable
    public AuthInfo getSecurityToken() {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    KinesisVideoCredentials credentials = DefaultAuthCallbacks.this.credentialsProvider.getUpdatedCredentials();
                    DefaultAuthCallbacks.this.expiration = credentials.getExpiration().getTime() * 10000L;
                    ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
                    outputStream.writeObject(credentials);
                    outputStream.flush();
                    DefaultAuthCallbacks.access$202(DefaultAuthCallbacks.this, byteArrayOutputStream.toByteArray());
                    outputStream.close();
                }
                catch (IOException e) {
                    DefaultAuthCallbacks.access$202(DefaultAuthCallbacks.this, null);
                    DefaultAuthCallbacks.this.expiration = 0L;
                    DefaultAuthCallbacks.this.log.exception(e, "Exception was thrown trying to get updated credentials", new Object[0]);
                }
                catch (KinesisVideoException e) {
                    DefaultAuthCallbacks.access$202(DefaultAuthCallbacks.this, null);
                    DefaultAuthCallbacks.this.expiration = 0L;
                    DefaultAuthCallbacks.this.log.exception(e, "Exception was thrown trying to get updated credentials", new Object[0]);
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e) {
                        DefaultAuthCallbacks.this.log.exception(e, "Closing the byte array stream threw an exception", new Object[0]);
                    }
                }
            }
        };
        ScheduledFuture<?> future = this.executor.schedule(task, 0L, TimeUnit.NANOSECONDS);
        try {
            future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.log.exception(e, "Awaiting for the credentials update threw an exception", new Object[0]);
        }
        catch (ExecutionException e) {
            this.log.exception(e, "Awaiting for the credentials update threw an exception", new Object[0]);
        }
        catch (TimeoutException e) {
            this.log.exception(e, "Awaiting for the credentials update threw an exception", new Object[0]);
        }
        return new AuthInfo(AuthInfoType.SECURITY_TOKEN, this.serializedCredentials, this.expiration);
    }

    @Override
    @Nullable
    public String getDeviceFingerprint() {
        throw new RuntimeException("Provisioning is not implemented");
    }

    static /* synthetic */ byte[] access$202(DefaultAuthCallbacks x0, byte[] x1) {
        x0.serializedCredentials = x1;
        return x1;
    }
}

