/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.GlobalTableDescription;
import com.amazonaws.services.dynamodbv2.model.transform.ReplicaDescriptionJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class GlobalTableDescriptionJsonUnmarshaller
implements Unmarshaller<GlobalTableDescription, JsonUnmarshallerContext> {
    private static GlobalTableDescriptionJsonUnmarshaller instance;

    GlobalTableDescriptionJsonUnmarshaller() {
    }

    public GlobalTableDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        GlobalTableDescription globalTableDescription = new GlobalTableDescription();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("ReplicationGroup")) {
                globalTableDescription.setReplicationGroup(new ListUnmarshaller((Unmarshaller)ReplicaDescriptionJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("GlobalTableArn")) {
                globalTableDescription.setGlobalTableArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CreationDateTime")) {
                globalTableDescription.setCreationDateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("GlobalTableStatus")) {
                globalTableDescription.setGlobalTableStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("GlobalTableName")) {
                globalTableDescription.setGlobalTableName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return globalTableDescription;
    }

    public static GlobalTableDescriptionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalTableDescriptionJsonUnmarshaller();
        }
        return instance;
    }
}

