/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.http.LoggingHandshakeCompletedListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TLS12SocketFactory
extends SSLSocketFactory {
    private static final Object contextLock = new Object();
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    private static SSLContext sslContext = null;
    private final SSLSocketFactory delegate;
    private LoggingHandshakeCompletedListener handshakeCompletedListener;

    @Nullable
    public static TLS12SocketFactory createTLS12SocketFactory() {
        return TLS12SocketFactory.createTLS12SocketFactory(null);
    }

    @Nullable
    public static TLS12SocketFactory createTLS12SocketFactory(@Nullable SSLContext sslContext) {
        if (Build.VERSION.SDK_INT < 21) {
            try {
                return new TLS12SocketFactory(sslContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void fixTLSPre21(@NonNull HttpsURLConnection connection) {
        TLS12SocketFactory.fixTLSPre21(connection, TLS12SocketFactory.createTLS12SocketFactory());
    }

    public static void fixTLSPre21(@NonNull HttpsURLConnection connection, @Nullable TLS12SocketFactory tls12SocketFactory) {
        if (Build.VERSION.SDK_INT < 21 && tls12SocketFactory != null) {
            try {
                connection.setSSLSocketFactory(tls12SocketFactory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLS12SocketFactory(@Nullable SSLContext customSSLContext) throws KeyManagementException, NoSuchAlgorithmException {
        if (customSSLContext != null) {
            this.delegate = customSSLContext.getSocketFactory();
        } else {
            Object object = contextLock;
            synchronized (object) {
                if (sslContext == null) {
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, null, null);
                }
            }
            this.delegate = sslContext.getSocketFactory();
        }
        this.handshakeCompletedListener = new LoggingHandshakeCompletedListener();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket();
        socket.addHandshakeCompletedListener(this.handshakeCompletedListener);
        return this.updateTLSProtocols(socket);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(s, host, port, autoClose);
        socket.addHandshakeCompletedListener(this.handshakeCompletedListener);
        return this.updateTLSProtocols(socket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port);
        socket.addHandshakeCompletedListener(this.handshakeCompletedListener);
        return this.updateTLSProtocols(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port, localHost, localPort);
        socket.addHandshakeCompletedListener(this.handshakeCompletedListener);
        return this.updateTLSProtocols(socket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port);
        socket.addHandshakeCompletedListener(this.handshakeCompletedListener);
        return this.updateTLSProtocols(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(address, port, localAddress, localPort);
        socket.addHandshakeCompletedListener(this.handshakeCompletedListener);
        return this.updateTLSProtocols(socket);
    }

    private Socket updateTLSProtocols(Socket socket) {
        if (socket instanceof SSLSocket) {
            try {
                ((SSLSocket)socket).setEnabledProtocols(SUPPORTED_PROTOCOLS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return socket;
    }
}

