/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;

public class LoggingHandshakeCompletedListener
implements HandshakeCompletedListener {
    private static final Log log = LogFactory.getLog(LoggingHandshakeCompletedListener.class);

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        try {
            SSLSession session = event.getSession();
            String protocol = session.getProtocol();
            String cipherSuite = session.getCipherSuite();
            log.debug("Protocol: " + protocol + ", CipherSuite: " + cipherSuite);
        }
        catch (Exception exception) {
            log.debug("Failed to log connection protocol/cipher suite", exception);
        }
    }
}

