/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssumeRoleWithWebIdentityRequestMarshaller
implements Marshaller<Request<AssumeRoleWithWebIdentityRequest>, AssumeRoleWithWebIdentityRequest> {
    @Override
    public Request<AssumeRoleWithWebIdentityRequest> marshall(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        String prefix;
        if (assumeRoleWithWebIdentityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AssumeRoleWithWebIdentityRequest)");
        }
        DefaultRequest<AssumeRoleWithWebIdentityRequest> request = new DefaultRequest<AssumeRoleWithWebIdentityRequest>(assumeRoleWithWebIdentityRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "AssumeRoleWithWebIdentity");
        request.addParameter("Version", "2011-06-15");
        if (assumeRoleWithWebIdentityRequest.getRoleArn() != null) {
            prefix = "RoleArn";
            String roleArn = assumeRoleWithWebIdentityRequest.getRoleArn();
            request.addParameter(prefix, StringUtils.fromString(roleArn));
        }
        if (assumeRoleWithWebIdentityRequest.getRoleSessionName() != null) {
            prefix = "RoleSessionName";
            String roleSessionName = assumeRoleWithWebIdentityRequest.getRoleSessionName();
            request.addParameter(prefix, StringUtils.fromString(roleSessionName));
        }
        if (assumeRoleWithWebIdentityRequest.getWebIdentityToken() != null) {
            prefix = "WebIdentityToken";
            String webIdentityToken = assumeRoleWithWebIdentityRequest.getWebIdentityToken();
            request.addParameter(prefix, StringUtils.fromString(webIdentityToken));
        }
        if (assumeRoleWithWebIdentityRequest.getProviderId() != null) {
            prefix = "ProviderId";
            String providerId = assumeRoleWithWebIdentityRequest.getProviderId();
            request.addParameter(prefix, StringUtils.fromString(providerId));
        }
        if (assumeRoleWithWebIdentityRequest.getPolicy() != null) {
            prefix = "Policy";
            String policy = assumeRoleWithWebIdentityRequest.getPolicy();
            request.addParameter(prefix, StringUtils.fromString(policy));
        }
        if (assumeRoleWithWebIdentityRequest.getDurationSeconds() != null) {
            prefix = "DurationSeconds";
            Integer durationSeconds = assumeRoleWithWebIdentityRequest.getDurationSeconds();
            request.addParameter(prefix, StringUtils.fromInteger(durationSeconds));
        }
        return request;
    }
}

