/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DateDeserializer
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private SimpleDateFormat mSimpleDateFormat;
    private final List<String> dateFormats;
    private final SimpleDateFormat mIso8601DateFormat;

    public DateDeserializer(String[] dateFormats) {
        this.dateFormats = Arrays.asList(dateFormats);
        this.mIso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public Date deserialize(JsonElement element, Type arg1, JsonDeserializationContext context) throws JsonParseException {
        String dateString = element.getAsString();
        Date date = null;
        for (String df : this.dateFormats) {
            try {
                date = new Date();
                this.mSimpleDateFormat = new SimpleDateFormat(df);
                date.setTime(this.mSimpleDateFormat.parse(dateString).getTime());
                return date;
            }
            catch (ParseException parseException) {
            }
        }
        try {
            return DateFormat.getDateInstance(2).parse(dateString);
        }
        catch (ParseException e) {
            throw new JsonParseException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        SimpleDateFormat simpleDateFormat = this.mIso8601DateFormat;
        synchronized (simpleDateFormat) {
            String dateFormatAsString = this.mIso8601DateFormat.format(src);
            return new JsonPrimitive(dateFormatAsString);
        }
    }
}

