/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public HttpRequest createHttpRequest(Request<?> request, ClientConfiguration clientConfiguration, ExecutionContext context) {
        boolean putParamsInUri;
        URI endpoint = request.getEndpoint();
        String uri = HttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = HttpUtils.encodeParameters(request);
        HttpMethodName method = request.getHttpMethod();
        boolean requestAlreadyHasPayload = request.getContent() != null;
        boolean requestIsPost = method == HttpMethodName.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestAlreadyHasPayload;
        if (encodedParams != null && putParamsInUri) {
            uri = uri + "?" + encodedParams;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.configureHeaders(headers, request, context, clientConfiguration);
        InputStream is = request.getContent();
        if (method == HttpMethodName.PATCH) {
            method = HttpMethodName.POST;
            headers.put("X-HTTP-Method-Override", HttpMethodName.PATCH.toString());
        }
        if (method == HttpMethodName.POST && request.getContent() == null && encodedParams != null) {
            byte[] contentBytes = encodedParams.getBytes(StringUtils.UTF8);
            is = new ByteArrayInputStream(contentBytes);
            headers.put("Content-Length", String.valueOf(contentBytes.length));
        }
        if (clientConfiguration.isEnableGzip() && headers.get("Accept-Encoding") == null) {
            headers.put("Accept-Encoding", "gzip");
        } else {
            headers.put("Accept-Encoding", "identity");
        }
        HttpRequest httpRequest = new HttpRequest(method.toString(), URI.create(uri), headers, is);
        httpRequest.setStreaming(request.isStreaming());
        return httpRequest;
    }

    private void configureHeaders(Map<String, String> headers, Request<?> request, ExecutionContext context, ClientConfiguration clientConfiguration) {
        URI endpoint = request.getEndpoint();
        String hostHeader = endpoint.getHost();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            hostHeader = hostHeader + ":" + endpoint.getPort();
        }
        headers.put("Host", hostHeader);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            headers.put(entry.getKey(), entry.getValue());
        }
        if (headers.get("Content-Type") == null || headers.get("Content-Type").isEmpty()) {
            headers.put("Content-Type", "application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase(DEFAULT_ENCODING));
        }
        if (context != null && context.getContextUserAgent() != null) {
            headers.put("User-Agent", this.createUserAgentString(clientConfiguration, context.getContextUserAgent()));
        }
    }

    private String createUserAgentString(ClientConfiguration clientConfiguration, String contextUserAgent) {
        if (clientConfiguration.getUserAgent().contains(contextUserAgent)) {
            return clientConfiguration.getUserAgent();
        }
        return clientConfiguration.getUserAgent() + " " + contextUserAgent;
    }
}

