/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidJsonUnmarshaller;
import com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    public boolean needsConnectionLeftOpen = false;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidJsonUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        log.trace((Object)"Parsing service response JSON");
        String CRC32Checksum = response.getHeaders().get("x-amz-crc32");
        CRC32ChecksumCalculatingInputStream crc32ChecksumInputStream = null;
        InputStream content = response.getRawContent();
        if (content == null) {
            content = new ByteArrayInputStream("{}".getBytes(StringUtils.UTF8));
        }
        if (CRC32Checksum != null) {
            crc32ChecksumInputStream = new CRC32ChecksumCalculatingInputStream(content);
            content = "gzip".equals(response.getHeaders().get("Content-Encoding")) ? new GZIPInputStream(crc32ChecksumInputStream) : crc32ChecksumInputStream;
        }
        AwsJsonReader jsonReader = JsonUtils.getJsonReader(new InputStreamReader(content));
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            JsonUnmarshallerContext unmarshallerContext = new JsonUnmarshallerContext(jsonReader, response);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            if (CRC32Checksum != null) {
                long serverSideCRC = Long.parseLong(CRC32Checksum);
                long clientSideCRC = crc32ChecksumInputStream.getCRC32Checksum();
                if (clientSideCRC != serverSideCRC) {
                    throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side");
                }
            }
            awsResponse.setResult(result);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("AWS_REQUEST_ID", response.getHeaders().get("x-amzn-RequestId"));
            awsResponse.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        finally {
            if (!this.needsConnectionLeftOpen) {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error closing json parser", (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }
}

