/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.CognitoIdentityProvider;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.transform.CognitoIdentityProviderJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class UpdateIdentityPoolRequestMarshaller
implements Marshaller<Request<UpdateIdentityPoolRequest>, UpdateIdentityPoolRequest> {
    @Override
    public Request<UpdateIdentityPoolRequest> marshall(UpdateIdentityPoolRequest updateIdentityPoolRequest) {
        if (updateIdentityPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateIdentityPoolRequest)");
        }
        DefaultRequest<UpdateIdentityPoolRequest> request = new DefaultRequest<UpdateIdentityPoolRequest>(updateIdentityPoolRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.UpdateIdentityPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (updateIdentityPoolRequest.getIdentityPoolId() != null) {
                String identityPoolId = updateIdentityPoolRequest.getIdentityPoolId();
                jsonWriter.name("IdentityPoolId");
                jsonWriter.value(identityPoolId);
            }
            if (updateIdentityPoolRequest.getIdentityPoolName() != null) {
                String identityPoolName = updateIdentityPoolRequest.getIdentityPoolName();
                jsonWriter.name("IdentityPoolName");
                jsonWriter.value(identityPoolName);
            }
            if (updateIdentityPoolRequest.getAllowUnauthenticatedIdentities() != null) {
                Boolean allowUnauthenticatedIdentities = updateIdentityPoolRequest.getAllowUnauthenticatedIdentities();
                jsonWriter.name("AllowUnauthenticatedIdentities");
                jsonWriter.value(allowUnauthenticatedIdentities);
            }
            if (updateIdentityPoolRequest.getSupportedLoginProviders() != null) {
                Map<String, String> supportedLoginProviders = updateIdentityPoolRequest.getSupportedLoginProviders();
                jsonWriter.name("SupportedLoginProviders");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> supportedLoginProvidersEntry : supportedLoginProviders.entrySet()) {
                    String supportedLoginProvidersValue = supportedLoginProvidersEntry.getValue();
                    if (supportedLoginProvidersValue == null) continue;
                    jsonWriter.name(supportedLoginProvidersEntry.getKey());
                    jsonWriter.value(supportedLoginProvidersValue);
                }
                jsonWriter.endObject();
            }
            if (updateIdentityPoolRequest.getDeveloperProviderName() != null) {
                String developerProviderName = updateIdentityPoolRequest.getDeveloperProviderName();
                jsonWriter.name("DeveloperProviderName");
                jsonWriter.value(developerProviderName);
            }
            if (updateIdentityPoolRequest.getOpenIdConnectProviderARNs() != null) {
                List<String> openIdConnectProviderARNs = updateIdentityPoolRequest.getOpenIdConnectProviderARNs();
                jsonWriter.name("OpenIdConnectProviderARNs");
                jsonWriter.beginArray();
                for (String openIdConnectProviderARNsItem : openIdConnectProviderARNs) {
                    if (openIdConnectProviderARNsItem == null) continue;
                    jsonWriter.value(openIdConnectProviderARNsItem);
                }
                jsonWriter.endArray();
            }
            if (updateIdentityPoolRequest.getCognitoIdentityProviders() != null) {
                List<CognitoIdentityProvider> cognitoIdentityProviders = updateIdentityPoolRequest.getCognitoIdentityProviders();
                jsonWriter.name("CognitoIdentityProviders");
                jsonWriter.beginArray();
                for (CognitoIdentityProvider cognitoIdentityProvidersItem : cognitoIdentityProviders) {
                    if (cognitoIdentityProvidersItem == null) continue;
                    CognitoIdentityProviderJsonMarshaller.getInstance().marshall(cognitoIdentityProvidersItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateIdentityPoolRequest.getSamlProviderARNs() != null) {
                List<String> samlProviderARNs = updateIdentityPoolRequest.getSamlProviderARNs();
                jsonWriter.name("SamlProviderARNs");
                jsonWriter.beginArray();
                for (String samlProviderARNsItem : samlProviderARNs) {
                    if (samlProviderARNsItem == null) continue;
                    jsonWriter.value(samlProviderARNsItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

